/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.recovery;

import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.recovery.DefaultRecoveryPlugin;
import org.jboss.jca.core.recovery.SecurityActions;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class ConfigurableRecoveryPlugin
implements RecoveryPlugin {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)DefaultRecoveryPlugin.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private boolean enableIsValid = true;
    private boolean isValidOverride = false;
    private int isValidValue = 5;
    private boolean enableClose = true;
    private String closeMethod = "close";

    public void setEnableIsValid(boolean v) {
        this.enableIsValid = v;
    }

    public void setIsValidValue(int v) {
        this.isValidValue = v;
    }

    public void setIsValidOverride(boolean v) {
        this.isValidOverride = v;
    }

    public void setEnableClose(boolean v) {
        this.enableClose = v;
    }

    public void setCloseMethod(String v) {
        this.closeMethod = v;
    }

    public boolean isValid(Object c) throws ResourceException {
        if (this.enableIsValid) {
            if (c != null) {
                try {
                    Method method = SecurityActions.getMethod(c.getClass(), "isValid", Integer.TYPE);
                    SecurityActions.setAccessible(method, true);
                    Boolean b = (Boolean)method.invoke(c, this.isValidValue);
                    return b;
                }
                catch (Throwable t) {
                    log.debugf("No isValid(int) method defined on connection interface (%s)", c.getClass().getName());
                }
            }
        } else {
            return this.isValidOverride;
        }
        return false;
    }

    public void close(Object c) throws ResourceException {
        if (this.enableClose && c != null) {
            if (c instanceof Connection) {
                try {
                    Connection cci = (Connection)c;
                    cci.close();
                }
                catch (ResourceException re) {
                    log.exceptionDuringConnectionClose(re);
                    throw new ResourceException(bundle.errorDuringConnectionClose(), (Throwable)re);
                }
            }
            try {
                Method method = SecurityActions.getMethod(c.getClass(), this.closeMethod, null);
                SecurityActions.setAccessible(method, true);
                method.invoke(c, (Object[])null);
            }
            catch (Throwable t) {
                log.debugf(t, "Error during connection %s()", this.closeMethod);
                throw new ResourceException(bundle.errorDuringConnectionClose(), t);
            }
        }
    }
}

