/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.ByteString;

public class SingleKeyBackupWriteCommand
extends BackupWriteCommand {
    public static final byte COMMAND_ID = 76;
    private static final Operation[] CACHED_OPERATION = Operation.values();
    private Operation operation;
    private Object key;
    private Object valueOrFunction;
    private Metadata metadata;
    private CacheNotifier cacheNotifier;
    private ComponentRegistry componentRegistry;
    private VersionGenerator versionGenerator;

    public SingleKeyBackupWriteCommand() {
        super(null);
    }

    public SingleKeyBackupWriteCommand(ByteString cacheName) {
        super(cacheName);
    }

    private static Operation valueOf(int index) {
        return CACHED_OPERATION[index];
    }

    public void init(InvocationContextFactory factory, AsyncInterceptorChain chain, CacheNotifier cacheNotifier, ComponentRegistry componentRegistry, VersionGenerator versionGenerator) {
        this.injectDependencies(factory, chain);
        this.cacheNotifier = cacheNotifier;
        this.componentRegistry = componentRegistry;
        this.versionGenerator = versionGenerator;
    }

    @Override
    public byte getCommandId() {
        return 76;
    }

    public void setPutKeyValueCommand(PutKeyValueCommand command) {
        this.operation = Operation.WRITE;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getValue();
        this.metadata = command.getMetadata();
    }

    public void setRemoveCommand(RemoveCommand command, boolean removeExpired) {
        this.operation = removeExpired ? Operation.REMOVE_EXPIRED : Operation.REMOVE;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getValue();
    }

    public void setReplaceCommand(ReplaceCommand command) {
        this.operation = Operation.REPLACE;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getNewValue();
        this.metadata = command.getMetadata();
    }

    public void setComputeCommand(ComputeCommand command) {
        this.operation = command.isComputeIfPresent() ? Operation.COMPUTE_IF_PRESENT : Operation.COMPUTE;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getRemappingBiFunction();
        this.metadata = command.getMetadata();
    }

    public void setComputeIfAbsentCommand(ComputeIfAbsentCommand command) {
        this.operation = Operation.COMPUTE_IF_ABSENT;
        this.setCommonAttributesFromCommand(command);
        this.key = command.getKey();
        this.valueOrFunction = command.getMappingFunction();
        this.metadata = command.getMetadata();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        this.writeBase(output);
        MarshallUtil.marshallEnum((Enum)this.operation, (ObjectOutput)output);
        output.writeObject(this.key);
        switch (this.operation) {
            case COMPUTE_IF_PRESENT: 
            case COMPUTE_IF_ABSENT: 
            case COMPUTE: 
            case REPLACE: 
            case WRITE: {
                output.writeObject(this.metadata);
            }
            case REMOVE_EXPIRED: {
                output.writeObject(this.valueOrFunction);
                break;
            }
            case REMOVE: {
                break;
            }
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.readBase(input);
        this.operation = (Operation)MarshallUtil.unmarshallEnum((ObjectInput)input, SingleKeyBackupWriteCommand::valueOf);
        this.key = input.readObject();
        switch (this.operation) {
            case COMPUTE_IF_PRESENT: 
            case COMPUTE_IF_ABSENT: 
            case COMPUTE: 
            case REPLACE: 
            case WRITE: {
                this.metadata = (Metadata)input.readObject();
            }
            case REMOVE_EXPIRED: {
                this.valueOrFunction = input.readObject();
                break;
            }
            case REMOVE: {
                break;
            }
        }
    }

    @Override
    public String toString() {
        return "SingleKeyBackupWriteCommand{" + this.toStringFields() + '}';
    }

    @Override
    WriteCommand createWriteCommand() {
        switch (this.operation) {
            case REMOVE: {
                return new RemoveCommand(this.key, null, this.cacheNotifier, this.segmentId, this.getFlags(), this.getCommandInvocationId());
            }
            case WRITE: {
                return new PutKeyValueCommand(this.key, this.valueOrFunction, false, this.cacheNotifier, this.metadata, this.segmentId, this.getTopologyId(), this.getCommandInvocationId());
            }
            case COMPUTE: {
                return new ComputeCommand(this.key, (BiFunction)this.valueOrFunction, false, this.segmentId, this.getFlags(), this.getCommandInvocationId(), this.metadata, this.cacheNotifier, this.componentRegistry);
            }
            case REPLACE: {
                return new ReplaceCommand(this.key, null, this.valueOrFunction, this.cacheNotifier, this.metadata, this.segmentId, this.getFlags(), this.getCommandInvocationId());
            }
            case REMOVE_EXPIRED: {
                return new RemoveExpiredCommand(this.key, this.valueOrFunction, null, false, this.cacheNotifier, this.segmentId, this.getCommandInvocationId(), this.versionGenerator.nonExistingVersion());
            }
            case COMPUTE_IF_PRESENT: {
                return new ComputeCommand(this.key, (BiFunction)this.valueOrFunction, true, this.segmentId, this.getFlags(), this.getCommandInvocationId(), this.metadata, this.cacheNotifier, this.componentRegistry);
            }
            case COMPUTE_IF_ABSENT: {
                return new ComputeIfAbsentCommand(this.key, (Function)this.valueOrFunction, this.segmentId, this.getFlags(), this.getCommandInvocationId(), this.metadata, this.cacheNotifier, this.componentRegistry);
            }
        }
        throw new IllegalStateException("Unknown operation " + (Object)((Object)this.operation));
    }

    @Override
    String toStringFields() {
        return super.toStringFields() + ", operation=" + (Object)((Object)this.operation) + ", key=" + this.key + ", valueOrFunction=" + this.valueOrFunction + ", metadata=" + this.metadata;
    }

    private static enum Operation {
        WRITE,
        REMOVE,
        REMOVE_EXPIRED,
        REPLACE,
        COMPUTE,
        COMPUTE_IF_PRESENT,
        COMPUTE_IF_ABSENT;

    }
}

