/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.expiration.RetrieveLastAccessCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ClusterExpirationManager<K, V>
extends ExpirationManagerImpl<K, V> {
    private static final Log log = LogFactory.getLog(ClusterExpirationManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int MAX_ASYNC_EXPIRATIONS = 5;
    @Inject
    protected AdvancedCache<K, V> cache;
    @Inject
    protected CommandsFactory cf;
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected DistributionManager distributionManager;

    @Override
    public void start() {
        super.start();
        this.cache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache();
    }

    @Override
    public void processExpiration() {
        long start = 0L;
        if (!Thread.currentThread().isInterrupted()) {
            try {
                if (trace) {
                    log.trace("Purging data container of expired entries");
                    start = this.timeService.time();
                }
                ArrayList futures = new ArrayList(5);
                long currentTimeMillis = this.timeService.wallClockTime();
                this.dataContainer.forEachIncludingExpired((ice, segment) -> {
                    if (ice.canExpire()) {
                        boolean expiredTransient;
                        boolean expiredMortal;
                        long maxIdle;
                        long lifespan;
                        Object value;
                        InternalCacheEntry internalCacheEntry = ice;
                        synchronized (internalCacheEntry) {
                            value = ice.getValue();
                            lifespan = ice.getLifespan();
                            maxIdle = ice.getMaxIdle();
                            expiredMortal = ExpiryHelper.isExpiredMortal(lifespan, ice.getCreated(), currentTimeMillis);
                            expiredTransient = ExpiryHelper.isExpiredTransient(maxIdle, ice.getLastUsed(), currentTimeMillis);
                        }
                        if (expiredMortal) {
                            this.addAndWaitIfFull(this.handleLifespanExpireEntry(ice.getKey(), value, lifespan), futures);
                        } else if (expiredTransient) {
                            this.addAndWaitIfFull(this.actualRemoveMaxIdleExpireEntry(ice.getKey(), value, maxIdle), futures);
                        }
                    }
                });
                if (!futures.isEmpty()) {
                    futures.forEach(CompletableFuture::join);
                }
                if (trace) {
                    log.tracef("Purging data container completed in %s", Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
                }
            }
            catch (Exception e) {
                log.exceptionPurgingDataContainer(e);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.persistenceManager.purgeExpired();
        }
    }

    private void addAndWaitIfFull(CompletableFuture future, List<CompletableFuture> futures) {
        futures.add(future);
        if (futures.size() == 5) {
            futures.forEach(CompletableFuture::join);
            futures.clear();
        }
    }

    CompletableFuture<Void> handleLifespanExpireEntry(K key, V value, long lifespan) {
        if (this.expiring.putIfAbsent(key, key) == null) {
            if (trace) {
                log.tracef("Submitting expiration removal for key %s which had lifespan of %s", Util.toStr(key), lifespan);
            }
            CompletableFuture<Void> future = this.cache.removeLifespanExpired(key, value, lifespan);
            return future.whenComplete((v, t) -> this.expiring.remove(key, key));
        }
        return CompletableFutures.completedNull();
    }

    CompletableFuture<Boolean> handleMaxIdleExpireEntry(K key, V value, long maxIdle) {
        return this.actualRemoveMaxIdleExpireEntry(key, value, maxIdle);
    }

    CompletableFuture<Boolean> actualRemoveMaxIdleExpireEntry(K key, V value, long maxIdle) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        CompletableFuture<Boolean> expiringObject = this.expiring.putIfAbsent(key, completableFuture);
        if (expiringObject == null) {
            if (trace) {
                log.tracef("Submitting expiration removal for key %s which had maxIdle of %s", Util.toStr(key), maxIdle);
            }
            completableFuture.whenComplete((b, t) -> this.expiring.remove(key, completableFuture));
            try {
                CompletableFuture<Boolean> expired = this.cache.removeMaxIdleExpired(key, value);
                expired.whenComplete((b, t) -> {
                    if (t != null) {
                        completableFuture.completeExceptionally((Throwable)t);
                    } else {
                        completableFuture.complete((Boolean)b);
                    }
                });
                return completableFuture;
            }
            catch (Throwable t2) {
                completableFuture.completeExceptionally(t2);
                throw t2;
            }
        }
        if (expiringObject instanceof CompletableFuture) {
            return expiringObject;
        }
        return CompletableFutures.completedTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> entryExpiredInMemory(InternalCacheEntry<K, V> entry, long currentTime) {
        boolean expiredMortal;
        long lifespan;
        Object value;
        InternalCacheEntry<K, V> internalCacheEntry = entry;
        synchronized (internalCacheEntry) {
            value = entry.getValue();
            lifespan = entry.getLifespan();
            expiredMortal = ExpiryHelper.isExpiredMortal(lifespan, entry.getCreated(), currentTime);
        }
        if (expiredMortal) {
            this.handleLifespanExpireEntry(entry.getKey(), value, lifespan);
            return CompletableFutures.completedTrue();
        }
        return this.handleMaxIdleExpireEntry(entry.getKey(), value, entry.getMaxIdle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> entryExpiredInMemoryFromIteration(InternalCacheEntry<K, V> entry, long currentTime) {
        boolean expiredTransient;
        InternalCacheEntry<K, V> internalCacheEntry = entry;
        synchronized (internalCacheEntry) {
            expiredTransient = ExpiryHelper.isExpiredTransient(entry.getMaxIdle(), entry.getLastUsed(), currentTime);
        }
        if (expiredTransient) {
            return CompletableFutures.completedFalse();
        }
        return CompletableFutures.completedTrue();
    }

    @Override
    public void handleInStoreExpiration(K key) {
        if (this.expiring.putIfAbsent(key, key) == null) {
            try {
                this.cache.removeLifespanExpired(key, null, null).join();
            }
            finally {
                this.expiring.remove(key, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInStoreExpiration(MarshalledEntry<K, V> marshalledEntry) {
        K key = marshalledEntry.getKey();
        if (this.expiring.putIfAbsent(key, key) == null) {
            try {
                InternalMetadata metadata = marshalledEntry.getMetadata();
                this.cache.removeLifespanExpired(key, marshalledEntry.getValue(), metadata.lifespan() == -1L ? null : Long.valueOf(metadata.lifespan())).join();
            }
            finally {
                this.expiring.remove(key, key);
            }
        }
    }

    @Override
    public CompletableFuture<Long> retrieveLastAccess(Object key, Object value, int segment) {
        Long access = this.localLastAccess(key, value, segment);
        LocalizedCacheTopology topology = this.distributionManager.getCacheTopology();
        DistributionInfo info = topology.getDistribution(key);
        if (trace) {
            log.tracef("Asking all read owners %s for key: %s - for latest access time", info.readOwners(), key);
        }
        RetrieveLastAccessCommand rlac = this.cf.buildRetrieveLastAccessCommand(key, value, segment);
        rlac.setTopologyId(topology.getTopologyId());
        return this.rpcManager.invokeCommand(info.readOwners(), (ReplicableCommand)rlac, new MaxResponseCollector<Long>(access), this.rpcManager.getSyncRpcOptions()).toCompletableFuture();
    }

    static class MaxResponseCollector<T extends Comparable<T>>
    extends ValidResponseCollector<T> {
        T highest;

        MaxResponseCollector(T highest) {
            this.highest = highest;
        }

        @Override
        public T finish() {
            return this.highest;
        }

        @Override
        protected T addValidResponse(Address sender, ValidResponse response) {
            Comparable value = (Comparable)response.getResponseValue();
            if (value != null && (this.highest == null || this.highest.compareTo((Comparable)value) < 0)) {
                this.highest = value;
            }
            return null;
        }

        @Override
        protected T addTargetNotFound(Address sender) {
            return null;
        }

        @Override
        protected T addException(Address sender, Exception exception) {
            throw ResponseCollectors.wrapRemoteException(sender, exception);
        }
    }
}

