/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.InvocationTargetException;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBProxyInformation;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.wildfly.common.math.HashMath;

final class EJBClientInterceptorInformation
implements Comparable<EJBClientInterceptorInformation> {
    static final EJBClientInterceptorInformation[] NO_INTERCEPTORS = new EJBClientInterceptorInformation[0];
    private static final ClassValue<EJBClientInterceptorInformation> CLASS_VALUE = new ClassValue<EJBClientInterceptorInformation>(){

        @Override
        protected EJBClientInterceptorInformation computeValue(Class<?> type) {
            Class<EJBClientInterceptor> subclass = type.asSubclass(EJBClientInterceptor.class);
            ClientInterceptorPriority annotation = EJBProxyInformation.ENABLE_SCANNING ? subclass.getAnnotation(ClientInterceptorPriority.class) : null;
            int priority = annotation != null ? annotation.value() : 0;
            return new EJBClientInterceptorInformation(subclass, priority);
        }
    };
    private volatile EJBClientInterceptor interceptorInstance;
    private final Class<? extends EJBClientInterceptor> interceptorClass;
    private final int priority;
    private EJBClientContext.InterceptorList singletonList;

    private EJBClientInterceptorInformation(EJBClientInterceptor interceptorInstance, int priority) {
        this.interceptorInstance = interceptorInstance;
        this.interceptorClass = interceptorInstance.getClass();
        this.priority = priority;
    }

    private EJBClientInterceptorInformation(Class<? extends EJBClientInterceptor> interceptorClass, int priority) {
        this.interceptorClass = interceptorClass;
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBClientInterceptor getInterceptorInstance() {
        EJBClientInterceptor interceptorInstance = this.interceptorInstance;
        if (interceptorInstance == null) {
            EJBClientInterceptorInformation eJBClientInterceptorInformation = this;
            synchronized (eJBClientInterceptorInformation) {
                interceptorInstance = this.interceptorInstance;
                if (interceptorInstance == null) {
                    Class<? extends EJBClientInterceptor> type = this.interceptorClass;
                    try {
                        interceptorInstance = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (InstantiationException | NoSuchMethodException e) {
                        throw Logs.MAIN.noInterceptorConstructor(type);
                    }
                    catch (IllegalAccessException e) {
                        throw Logs.MAIN.interceptorConstructorNotAccessible(type);
                    }
                    catch (InvocationTargetException e) {
                        throw Logs.MAIN.interceptorConstructorFailed(type, e.getCause());
                    }
                }
                this.interceptorInstance = interceptorInstance;
            }
        }
        return interceptorInstance;
    }

    int getPriority() {
        return this.priority;
    }

    public int hashCode() {
        return HashMath.multiHashOrdered(System.identityHashCode(this.interceptorInstance), this.priority);
    }

    static EJBClientInterceptorInformation forClass(Class<?> interceptorClass) {
        return CLASS_VALUE.get(interceptorClass);
    }

    static EJBClientInterceptorInformation forInstance(EJBClientInterceptor interceptor) {
        EJBClientInterceptorInformation classInfo = CLASS_VALUE.get(interceptor.getClass());
        try {
            if (classInfo.getInterceptorInstance() == interceptor) {
                return classInfo;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new EJBClientInterceptorInformation(interceptor, classInfo.priority);
    }

    EJBClientContext.InterceptorList getSingletonList() {
        EJBClientContext.InterceptorList singletonList = this.singletonList;
        if (singletonList == null) {
            this.singletonList = new EJBClientContext.InterceptorList(new EJBClientInterceptorInformation[]{this});
            return this.singletonList;
        }
        return singletonList;
    }

    @Override
    public int compareTo(EJBClientInterceptorInformation o) {
        return Integer.signum(this.priority - o.priority);
    }
}

