/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.util.Util;

public class MsgStats {
    protected final LongAdder num_msgs_sent = new LongAdder();
    protected final LongAdder num_msgs_received = new LongAdder();
    protected final LongAdder num_single_msgs_sent = new LongAdder();
    protected final LongAdder num_oob_msgs_received = new LongAdder();
    protected final LongAdder num_internal_msgs_received = new LongAdder();
    protected final LongAdder num_batches_sent = new LongAdder();
    protected final LongAdder num_batches_received = new LongAdder();
    protected final LongAdder num_bytes_sent = new LongAdder();
    protected final LongAdder num_bytes_received = new LongAdder();
    protected final AtomicInteger num_rejected_msgs = new AtomicInteger(0);
    protected final AtomicInteger num_threads_spawned = new AtomicInteger(0);

    @ManagedAttribute(description="Number of messages sent")
    public long getNumMsgsSent() {
        return this.num_msgs_sent.sum();
    }

    public MsgStats incrNumMsgsSent(int d) {
        this.num_msgs_sent.add(d);
        return this;
    }

    @ManagedAttribute(description="Number of regular messages received")
    public long getNumMsgsReceived() {
        return this.num_msgs_received.sum();
    }

    public MsgStats incrNumMsgsReceived(int d) {
        this.num_msgs_received.add(d);
        return this;
    }

    @ManagedAttribute(description="Number of OOB messages received. This value is included in num_msgs_received.")
    public long getNumOOBMsgsReceived() {
        return this.num_oob_msgs_received.sum();
    }

    public MsgStats incrNumOOBMsgsReceived(int d) {
        this.num_oob_msgs_received.add(d);
        return this;
    }

    @ManagedAttribute(description="Number of internal messages received. This value is included in num_msgs_received.")
    public long getNumInternalMsgsReceived() {
        return this.num_internal_msgs_received.sum();
    }

    public MsgStats incrNumInternalMsgsReceived(int d) {
        this.num_internal_msgs_received.add(d);
        return this;
    }

    @ManagedAttribute(description="Number of single messages sent")
    public long getNumSingleMsgsSent() {
        return this.num_single_msgs_sent.sum();
    }

    public MsgStats incrNumSingleMsgsSent(int d) {
        this.num_single_msgs_sent.add(d);
        return this;
    }

    @ManagedAttribute(description="Number of message batches sent")
    public long getNumBatchesSent() {
        return this.num_batches_sent.sum();
    }

    public MsgStats incrNumBatchesSent(int d) {
        this.num_batches_sent.add(d);
        return this;
    }

    @ManagedAttribute(description="Number of message batches received")
    public long getNumBatchesReceived() {
        return this.num_batches_received.sum();
    }

    public MsgStats incrNumBatchesReceived(int d) {
        this.num_batches_received.add(d);
        return this;
    }

    @ManagedAttribute(description="Number of bytes sent")
    public long getNumBytesSent() {
        return this.num_bytes_sent.sum();
    }

    public MsgStats incrNumBytesSent(int d) {
        this.num_bytes_sent.add(d);
        return this;
    }

    @ManagedAttribute(description="Number of bytes received")
    public long getNumBytesReceived() {
        return this.num_bytes_received.sum();
    }

    public MsgStats incrNumBytesReceived(int d) {
        this.num_bytes_received.add(d);
        return this;
    }

    @ManagedAttribute(description="Number of dropped messages that were rejected by the thread pool")
    public int getNumRejectedMsgs() {
        return this.num_rejected_msgs.get();
    }

    public MsgStats incrNumRejectedMsgs(int d) {
        this.num_rejected_msgs.addAndGet(d);
        return this;
    }

    @ManagedAttribute(description="Number of threads spawned as a result of thread pool rejection")
    public int getNumThreadsSpawned() {
        return this.num_threads_spawned.get();
    }

    public MsgStats incrNumThreadsSpawned(int d) {
        this.num_threads_spawned.addAndGet(d);
        return this;
    }

    public MsgStats reset() {
        Stream.of(this.num_msgs_sent, this.num_msgs_received, this.num_single_msgs_sent, this.num_oob_msgs_received, this.num_internal_msgs_received, this.num_batches_sent, this.num_batches_received, this.num_bytes_sent, this.num_bytes_received).forEach(LongAdder::reset);
        Stream.of(this.num_rejected_msgs, this.num_threads_spawned).forEach(ai -> ai.set(0));
        return this;
    }

    public String toString() {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        for (Field field : fields = MsgStats.class.getDeclaredFields()) {
            try {
                Object val = Util.getField(field, this);
                sb.append(field.getName()).append(": ").append(val).append("\n");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

