/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.MemberSubstitution;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.internal.bytebuddy.HibernateMethodLookupDispatcher;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.proxy.ProxyConfiguration;

public final class ByteBuddyState {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ByteBuddyState.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final boolean DEBUG = false;
    private final ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
    private final AsmVisitorWrapper.ForDeclaredMethods getDeclaredMethodMemberSubstitution;
    private final AsmVisitorWrapper.ForDeclaredMethods getMethodMemberSubstitution;
    private final ProxyDefinitionHelpers proxyDefinitionHelpers;
    private final TypeCache<TypeCache.SimpleKey> proxyCache = new TypeCache.WithInlineExpunction(TypeCache.Sort.WEAK);
    private final TypeCache<TypeCache.SimpleKey> basicProxyCache = new TypeCache.WithInlineExpunction(TypeCache.Sort.WEAK);

    ByteBuddyState() {
        if (System.getSecurityManager() != null) {
            this.getDeclaredMethodMemberSubstitution = ByteBuddyState.getDeclaredMethodMemberSubstitution();
            this.getMethodMemberSubstitution = ByteBuddyState.getMethodMemberSubstitution();
        } else {
            this.getDeclaredMethodMemberSubstitution = null;
            this.getMethodMemberSubstitution = null;
        }
        this.proxyDefinitionHelpers = new ProxyDefinitionHelpers();
    }

    public Class<?> loadProxy(Class<?> referenceClass, TypeCache.SimpleKey cacheKey, Function<ByteBuddy, DynamicType.Builder<?>> makeProxyFunction) {
        return this.load(referenceClass, this.proxyCache, cacheKey, makeProxyFunction);
    }

    Class<?> loadBasicProxy(Class<?> referenceClass, TypeCache.SimpleKey cacheKey, Function<ByteBuddy, DynamicType.Builder<?>> makeProxyFunction) {
        return this.load(referenceClass, this.basicProxyCache, cacheKey, makeProxyFunction);
    }

    public Class<?> load(Class<?> referenceClass, Function<ByteBuddy, DynamicType.Builder<?>> makeClassFunction) {
        return this.make(makeClassFunction.apply(this.byteBuddy)).load(referenceClass.getClassLoader(), ByteBuddyState.resolveClassLoadingStrategy(referenceClass)).getLoaded();
    }

    public byte[] rewrite(TypePool typePool, String className, byte[] originalBytes, Function<ByteBuddy, DynamicType.Builder<?>> rewriteClassFunction) {
        DynamicType.Builder<?> builder = rewriteClassFunction.apply(this.byteBuddy);
        if (builder == null) {
            return originalBytes;
        }
        return this.make(typePool, builder).getBytes();
    }

    public ProxyDefinitionHelpers getProxyDefinitionHelpers() {
        return this.proxyDefinitionHelpers;
    }

    void clearState() {
        this.proxyCache.clear();
        this.basicProxyCache.clear();
    }

    private Class<?> load(Class<?> referenceClass, TypeCache<TypeCache.SimpleKey> cache, TypeCache.SimpleKey cacheKey, Function<ByteBuddy, DynamicType.Builder<?>> makeProxyFunction) {
        return cache.findOrInsert(referenceClass.getClassLoader(), (Object)cacheKey, () -> this.make((DynamicType.Builder)makeProxyFunction.apply(this.byteBuddy)).load(referenceClass.getClassLoader(), ByteBuddyState.resolveClassLoadingStrategy(referenceClass)).getLoaded(), cache);
    }

    private DynamicType.Unloaded<?> make(DynamicType.Builder<?> builder) {
        return this.make(null, builder);
    }

    private DynamicType.Unloaded<?> make(TypePool typePool, DynamicType.Builder<?> builder) {
        if (System.getSecurityManager() != null) {
            builder = builder.visit((AsmVisitorWrapper)this.getDeclaredMethodMemberSubstitution);
            builder = builder.visit((AsmVisitorWrapper)this.getMethodMemberSubstitution);
        }
        DynamicType.Unloaded unloadedClass = typePool != null ? builder.make(typePool) : builder.make();
        if (System.getSecurityManager() != null) {
            HibernateMethodLookupDispatcher.registerAuthorizedClass(unloadedClass.getTypeDescription().getName());
        }
        return unloadedClass;
    }

    public static ClassLoadingStrategy<ClassLoader> resolveClassLoadingStrategy(Class<?> originalClass) {
        if (ClassInjector.UsingLookup.isAvailable()) {
            Method privateLookupIn;
            try {
                privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            }
            catch (Exception e) {
                throw new HibernateException(LOG.bytecodeEnhancementFailed(originalClass.getName()), e);
            }
            try {
                Object privateLookup;
                try {
                    privateLookup = privateLookupIn.invoke(null, originalClass, LOOKUP);
                }
                catch (InvocationTargetException exception) {
                    if (exception.getCause() instanceof IllegalAccessException) {
                        return new ClassLoadingStrategy.ForUnsafeInjection(originalClass.getProtectionDomain());
                    }
                    throw new HibernateException(LOG.bytecodeEnhancementFailed(originalClass.getName()), exception.getCause());
                }
                return ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
            }
            catch (Throwable e) {
                throw new HibernateException(LOG.bytecodeEnhancementFailedUnableToGetPrivateLookupFor(originalClass.getName()), e);
            }
        }
        return new ClassLoadingStrategy.ForUnsafeInjection(originalClass.getProtectionDomain());
    }

    private static AsmVisitorWrapper.ForDeclaredMethods getDeclaredMethodMemberSubstitution() {
        return MemberSubstitution.relaxed().method((ElementMatcher)ElementMatchers.is((Method)AccessController.doPrivileged(new GetDeclaredMethodAction((Class)Class.class, "getDeclaredMethod", new Class[]{String.class, Class[].class})))).replaceWith(AccessController.doPrivileged(new GetDeclaredMethodAction((Class)HibernateMethodLookupDispatcher.class, "getDeclaredMethod", new Class[]{Class.class, String.class, Class[].class}))).on((ElementMatcher)ElementMatchers.isTypeInitializer());
    }

    private static AsmVisitorWrapper.ForDeclaredMethods getMethodMemberSubstitution() {
        return MemberSubstitution.relaxed().method((ElementMatcher)ElementMatchers.is((Method)AccessController.doPrivileged(new GetDeclaredMethodAction((Class)Class.class, "getMethod", new Class[]{String.class, Class[].class})))).replaceWith(AccessController.doPrivileged(new GetDeclaredMethodAction((Class)HibernateMethodLookupDispatcher.class, "getMethod", new Class[]{Class.class, String.class, Class[].class}))).on((ElementMatcher)ElementMatchers.isTypeInitializer());
    }

    public static class ProxyDefinitionHelpers {
        private final ElementMatcher<? super MethodDescription> groovyGetMetaClassFilter = ElementMatchers.isSynthetic().and((ElementMatcher)ElementMatchers.named((String)"getMetaClass").and((ElementMatcher)ElementMatchers.returns(td -> "groovy.lang.MetaClass".equals(td.getName()))));
        private final ElementMatcher<? super MethodDescription> virtualNotFinalizerFilter = ElementMatchers.isVirtual().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isFinalizer()));
        private final ElementMatcher<? super MethodDescription> hibernateGeneratedMethodFilter = ElementMatchers.nameStartsWith((String)"$$_hibernate_").and((ElementMatcher)ElementMatchers.isVirtual());
        private final MethodDelegation delegateToInterceptorDispatcherMethodDelegation;
        private final FieldAccessor.PropertyConfigurable interceptorFieldAccessor;

        private ProxyDefinitionHelpers() {
            PrivilegedAction<MethodDelegation> delegateToInterceptorDispatcherMethodDelegationPrivilegedAction = new PrivilegedAction<MethodDelegation>(){

                @Override
                public MethodDelegation run() {
                    return MethodDelegation.to(ProxyConfiguration.InterceptorDispatcher.class);
                }
            };
            this.delegateToInterceptorDispatcherMethodDelegation = System.getSecurityManager() != null ? AccessController.doPrivileged(delegateToInterceptorDispatcherMethodDelegationPrivilegedAction) : (MethodDelegation)delegateToInterceptorDispatcherMethodDelegationPrivilegedAction.run();
            PrivilegedAction<FieldAccessor.PropertyConfigurable> interceptorFieldAccessorPrivilegedAction = new PrivilegedAction<FieldAccessor.PropertyConfigurable>(){

                @Override
                public FieldAccessor.PropertyConfigurable run() {
                    return FieldAccessor.ofField((String)"$$_hibernate_interceptor").withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
                }
            };
            this.interceptorFieldAccessor = System.getSecurityManager() != null ? AccessController.doPrivileged(interceptorFieldAccessorPrivilegedAction) : (FieldAccessor.PropertyConfigurable)interceptorFieldAccessorPrivilegedAction.run();
        }

        public ElementMatcher<? super MethodDescription> getGroovyGetMetaClassFilter() {
            return this.groovyGetMetaClassFilter;
        }

        public ElementMatcher<? super MethodDescription> getVirtualNotFinalizerFilter() {
            return this.virtualNotFinalizerFilter;
        }

        public ElementMatcher<? super MethodDescription> getHibernateGeneratedMethodFilter() {
            return this.hibernateGeneratedMethodFilter;
        }

        public MethodDelegation getDelegateToInterceptorDispatcherMethodDelegation() {
            return this.delegateToInterceptorDispatcherMethodDelegation;
        }

        public FieldAccessor.PropertyConfigurable getInterceptorFieldAccessor() {
            return this.interceptorFieldAccessor;
        }
    }

    private static class GetDeclaredMethodAction
    implements PrivilegedAction<Method> {
        private final Class<?> clazz;
        private final String methodName;
        private final Class<?>[] parameterTypes;

        private GetDeclaredMethodAction(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        @Override
        public Method run() {
            try {
                Method method = this.clazz.getDeclaredMethod(this.methodName, this.parameterTypes);
                return method;
            }
            catch (NoSuchMethodException e) {
                throw new HibernateException("Unable to prepare getDeclaredMethod()/getMethod() substitution", e);
            }
        }
    }
}

