/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.util;

import java.io.IOException;
import java.util.List;
import org.jboss.as.jdr.util.Utils;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class FSTree {
    int directoryCount = 0;
    int fileCount = 0;
    StringBuilder buf = new StringBuilder();
    String topDirectory = null;
    String fmt = "%s%s%s %s";

    public FSTree(String root) throws Exception {
        this.traverse(root, "", true);
    }

    private static double div(long left, long right) {
        return (double)left / (double)right;
    }

    private static String formatBytes(long size) {
        if (size > 0x10000000000L) {
            return String.format("%.1fT", FSTree.div(size, 0x10000000000L));
        }
        if (size > 0x40000000L) {
            return String.format("%.1fG", FSTree.div(size, 0x40000000L));
        }
        if (size > 0x100000L) {
            return String.format("%.1fM", FSTree.div(size, 0x100000L));
        }
        if (size > 1024L) {
            return String.format("%.1fK", FSTree.div(size, 1024L));
        }
        return String.format("%d", size);
    }

    private void traverse(String dir, String padding) throws IOException {
        this.traverse(dir, padding, false);
    }

    private void append(VirtualFile f, String padding) {
        String baseName = f.getName();
        String size = FSTree.formatBytes(f.getSize());
        this.buf.append(String.format(this.fmt, padding, "+-- ", size, baseName));
        this.buf.append("\n");
    }

    private void traverse(String dir, String padding, boolean first) throws IOException {
        VirtualFile path = VFS.getChild((String)dir);
        if (!first) {
            String _p = padding.substring(0, padding.length() - 1);
            this.append(path, _p);
            padding = padding + "   ";
        } else {
            this.buf.append(path.getName());
            this.buf.append("\n");
        }
        int count = 0;
        List files = path.getChildren();
        for (VirtualFile f : files) {
            ++count;
            if (f.getPathName().startsWith(".")) continue;
            if (f.isFile()) {
                this.append(f, padding);
                continue;
            }
            if (Utils.isSymlink(f)) {
                this.buf.append(padding);
                this.buf.append("+-- ");
                this.buf.append(f.getName());
                this.buf.append(" -> ");
                this.buf.append(f.getPathName());
                this.buf.append("\n");
                continue;
            }
            if (!f.isDirectory()) continue;
            if (count == files.size()) {
                this.traverse(f.getPathName(), padding + " ");
                continue;
            }
            this.traverse(f.getPathName(), padding + "|");
        }
    }

    public String toString() {
        return this.buf.toString();
    }
}

