/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.backend.impl.TransactionalOperationDispatcher;
import org.hibernate.search.backend.impl.batch.DefaultBatchBackend;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.backend.spi.OperationDispatcher;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.impl.AnalyzerRegistry;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.impl.LuceneQueryDescriptor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.integration.impl.SearchIntegration;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.TimingSource;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.indexes.IndexFamily;
import org.hibernate.search.indexes.IndexFamilyType;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.indexes.impl.DefaultIndexReaderAccessor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.jmx.StatisticsInfoMBean;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorForUnindexedType;
import org.hibernate.search.metadata.impl.IndexedTypeDescriptorImpl;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedQueryContextBuilder;
import org.hibernate.search.query.engine.impl.LuceneQueryTranslator;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.impl.ExtendedSearchIntegratorWithShareableState;
import org.hibernate.search.spi.impl.IndexedTypeMaps;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.spi.impl.TypeHierarchy;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.stat.impl.StatisticsImpl;
import org.hibernate.search.stat.spi.StatisticsImplementor;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.Closer;
import org.hibernate.search.util.jmx.impl.JMXRegistrar;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ImmutableSearchFactory
implements ExtendedSearchIntegratorWithShareableState,
WorkerBuildContext {
    private static final Log log;
    private final IndexedTypeMap<EntityIndexBinding> indexBindingForEntities;
    private final IndexedTypeMap<DocumentBuilderContainedEntity> documentBuildersContainedEntities;
    private final IndexedTypeMap<IndexedTypeDescriptor> indexedTypeDescriptors;
    private final Worker worker;
    private final Map<String, FilterDef> filterDefinitions;
    private final FilterCachingStrategy filterCachingStrategy;
    private final Map<IndexManagerType, SearchIntegration> integrations;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final int cacheBitResultsSize;
    private final Properties configurationProperties;
    private final TypeHierarchy configuredTypeHierarchy;
    private final TypeHierarchy indexedTypeHierarchy;
    private final StatisticsImpl statistics;
    private final boolean transactionManagerExpected;
    private final IndexManagerHolder allIndexesManager;
    private final ErrorHandler errorHandler;
    private final IndexingMode indexingMode;
    private final ServiceManager serviceManager;
    private final boolean queryTranslatorPresent;
    private final boolean enableDirtyChecks;
    private final DefaultIndexReaderAccessor indexReaderAccessor;
    private final InstanceInitializer instanceInitializer;
    private final TimeoutExceptionFactory timeoutExceptionFactory;
    private final TimingSource timingSource;
    private final SearchMapping mapping;
    private final boolean indexMetadataIsComplete;
    private final boolean isDeleteByTermEnforced;
    private final boolean isIdProvidedImplicit;
    private final boolean isMultitenancyEnabled;
    private final String statisticsMBeanName;
    private final IndexManagerFactory indexManagerFactory;
    private final ObjectLookupMethod defaultObjectLookupMethod;
    private final DatabaseRetrievalMethod defaultDatabaseRetrievalMethod;
    private final boolean enlistWorkerInTransaction;
    private final boolean indexUninvertingAllowed;
    private volatile LuceneWorkSerializer workSerializer;

    public ImmutableSearchFactory(SearchFactoryState state) {
        this.integrations = state.getIntegrations();
        this.cacheBitResultsSize = state.getCacheBitResultsSize();
        this.configurationProperties = state.getConfigurationProperties();
        this.indexBindingForEntities = state.getIndexBindings();
        this.documentBuildersContainedEntities = state.getDocumentBuildersContainedEntities();
        this.filterCachingStrategy = state.getFilterCachingStrategy();
        this.filterDefinitions = state.getFilterDefinitions();
        this.configuredTypeHierarchy = state.getConfiguredTypeHierarchy();
        this.indexedTypeHierarchy = state.getIndexedTypeHierarchy();
        this.indexingMode = state.getIndexingMode();
        this.worker = state.getWorker();
        this.serviceManager = state.getServiceManager();
        this.queryTranslatorPresent = this.determineQueryTranslatorPresent();
        this.transactionManagerExpected = state.isTransactionManagerExpected();
        this.allIndexesManager = state.getAllIndexesManager();
        this.errorHandler = state.getErrorHandler();
        this.instanceInitializer = state.getInstanceInitializer();
        this.timeoutExceptionFactory = state.getDefaultTimeoutExceptionFactory();
        this.timingSource = state.getTimingSource();
        this.mapping = state.getProgrammaticMapping();
        if (state.getStatistics() == null) {
            this.statistics = new StatisticsImpl(this);
            boolean statsEnabled = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.generate_statistics", false);
            this.statistics.setStatisticsEnabled(statsEnabled);
        } else {
            this.statistics = (StatisticsImpl)state.getStatistics();
        }
        this.indexMetadataIsComplete = state.isIndexMetadataComplete();
        this.isDeleteByTermEnforced = state.isDeleteByTermEnforced();
        this.isIdProvidedImplicit = state.isIdProvidedImplicit();
        this.isMultitenancyEnabled = state.isMultitenancyEnabled();
        this.indexManagerFactory = state.getIndexManagerFactory();
        this.workSerializer = state.getWorkSerializerState();
        this.enableDirtyChecks = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.enable_dirty_check", true);
        this.statisticsMBeanName = this.isJMXEnabled() ? this.registerMBeans() : null;
        this.indexReaderAccessor = new DefaultIndexReaderAccessor(this);
        this.indexedTypeDescriptors = IndexedTypeMaps.concurrentHashMap();
        this.defaultObjectLookupMethod = this.determineDefaultObjectLookupMethod();
        this.defaultDatabaseRetrievalMethod = this.determineDefaultDatabaseRetrievalMethod();
        this.enlistWorkerInTransaction = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.worker.enlist_in_transaction", false);
        this.indexUninvertingAllowed = ConfigurationParseHelper.getBooleanValue(this.configurationProperties, "hibernate.search.index_uninverting_allowed", false);
    }

    private ObjectLookupMethod determineDefaultObjectLookupMethod() {
        String objectLookupMethod = this.configurationProperties.getProperty("hibernate.search.query.object_lookup_method");
        if (objectLookupMethod == null) {
            return ObjectLookupMethod.SKIP;
        }
        try {
            return Enum.valueOf(ObjectLookupMethod.class, objectLookupMethod.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw log.invalidPropertyValue(objectLookupMethod, "hibernate.search.query.object_lookup_method");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean determineQueryTranslatorPresent() {
        try (ServiceReference<LuceneQueryTranslator> translator = this.getServiceManager().requestReference(LuceneQueryTranslator.class);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private DatabaseRetrievalMethod determineDefaultDatabaseRetrievalMethod() {
        String databaseRetrievalMethod = this.configurationProperties.getProperty("hibernate.search.query.database_retrieval_method");
        if (databaseRetrievalMethod == null) {
            return DatabaseRetrievalMethod.QUERY;
        }
        try {
            return Enum.valueOf(DatabaseRetrievalMethod.class, databaseRetrievalMethod.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw log.invalidPropertyValue(databaseRetrievalMethod, "hibernate.search.query.object_lookup_method");
        }
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.filterDefinitions;
    }

    @Override
    public IndexingMode getIndexingMode() {
        return this.indexingMode;
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            try (Closer closer = new Closer();){
                closer.push(() -> {
                    try {
                        this.worker.close();
                    }
                    catch (Exception e) {
                        log.workerException(e);
                    }
                });
                closer.push(this.allIndexesManager::stop);
                closer.push(this.timingSource::stop);
                if (this.workSerializer != null) {
                    closer.push(this.serviceManager::releaseService, LuceneWorkSerializer.class);
                }
                closer.pushAll(SearchIntegration::close, this.integrations.values());
                closer.push(this.serviceManager::releaseAllServices);
                if (this.statisticsMBeanName != null) {
                    closer.push(JMXRegistrar::unRegisterMBean, this.statisticsMBeanName);
                }
            }
        }
    }

    @Override
    public HSQuery createHSQuery(Query luceneQuery, Class<?> ... entityTypes) {
        IndexedTypeSet newtypes = IndexedTypeSets.fromClasses(entityTypes);
        QueryDescriptor descriptor = this.createQueryDescriptor(luceneQuery, newtypes);
        return descriptor.createHSQuery((SearchIntegrator)this, newtypes);
    }

    @Override
    public HSQuery createHSQuery(Query luceneQuery, IndexedTypeMap<CustomTypeMetadata> types) {
        IndexedTypeSet entityTypes = types.keySet();
        QueryDescriptor descriptor = this.createQueryDescriptor(luceneQuery, entityTypes);
        return descriptor.createHSQuery((SearchIntegrator)this, types);
    }

    private QueryDescriptor createQueryDescriptor(Query luceneQuery, IndexedTypeSet entityTypes) {
        QueryDescriptor descriptor = null;
        if (this.queryTranslatorPresent) {
            try (ServiceReference<LuceneQueryTranslator> translator = this.getServiceManager().requestReference(LuceneQueryTranslator.class);){
                if (translator.get().conversionRequired(entityTypes)) {
                    descriptor = translator.get().convertLuceneQuery(luceneQuery);
                }
            }
        }
        if (descriptor == null) {
            descriptor = new LuceneQueryDescriptor(luceneQuery);
        }
        return descriptor;
    }

    @Override
    public IndexedTypeMap<DocumentBuilderContainedEntity> getDocumentBuildersContainedEntities() {
        return this.documentBuildersContainedEntities;
    }

    @Override
    public IndexedTypeMap<EntityIndexBinding> getIndexBindings() {
        return this.indexBindingForEntities;
    }

    @Override
    public EntityIndexBinding getIndexBinding(IndexedTypeIdentifier entityType) {
        return this.indexBindingForEntities.get(entityType);
    }

    @Override
    public DocumentBuilderContainedEntity getDocumentBuilderContainedEntity(IndexedTypeIdentifier entityType) {
        return this.documentBuildersContainedEntities.get(entityType);
    }

    @Override
    public void addClasses(Class<?> ... classes) {
        throw new AssertionFailure("Cannot add classes to an " + ImmutableSearchFactory.class.getName());
    }

    @Override
    public Worker getWorker() {
        return this.worker;
    }

    @Override
    public void optimize() {
        for (IndexManager im : this.allIndexesManager.getIndexManagers()) {
            im.optimize();
        }
    }

    @Override
    public void optimize(IndexedTypeIdentifier entityType) {
        EntityIndexBinding entityIndexBinding = this.getSafeIndexBindingForEntity(entityType);
        for (IndexManager im : entityIndexBinding.getIndexManagerSelector().all()) {
            im.optimize();
        }
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        SearchIntegration integration = this.integrations.get(LuceneEmbeddedIndexManagerType.INSTANCE);
        AnalyzerRegistry registry = integration.getAnalyzerRegistry();
        if (registry == null) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        AnalyzerReference reference = registry.getAnalyzerReference(name);
        if (reference == null || !reference.is(LuceneAnalyzerReference.class)) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        Analyzer analyzer = reference.unwrap(LuceneAnalyzerReference.class).getAnalyzer();
        if (analyzer == null) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        return analyzer;
    }

    @Override
    public SearchIntegration getIntegration(IndexManagerType indexManagerType) {
        SearchIntegration integration = this.integrations.get(indexManagerType);
        if (integration == null) {
            throw new SearchException("Unknown index manager type: " + indexManagerType);
        }
        return integration;
    }

    @Override
    public Analyzer getAnalyzer(IndexedTypeIdentifier type) {
        return this.getAnalyzerReference(type).unwrap(LuceneAnalyzerReference.class).getAnalyzer();
    }

    @Override
    public ScopedAnalyzerReference getAnalyzerReference(IndexedTypeIdentifier type) {
        EntityIndexBinding entityIndexBinding = this.getSafeIndexBindingForEntity(type);
        DocumentBuilderIndexedEntity builder = entityIndexBinding.getDocumentBuilder();
        return builder.getAnalyzerReference();
    }

    @Override
    public QueryContextBuilder buildQueryBuilder() {
        return new ConnectedQueryContextBuilder(this);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.statistics;
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.filterCachingStrategy;
    }

    @Override
    public Map<IndexManagerType, SearchIntegration> getIntegrations() {
        return this.integrations;
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        return this.filterDefinitions.get(name);
    }

    @Override
    public int getFilterCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public IndexedTypeSet getConfiguredTypesPolymorphic(IndexedTypeSet types) {
        return this.configuredTypeHierarchy.getConfiguredClasses(types);
    }

    @Override
    public IndexedTypeSet getIndexedTypesPolymorphic(IndexedTypeSet types) {
        return this.indexedTypeHierarchy.getConfiguredClasses(types);
    }

    @Override
    public BatchBackend makeBatchBackend(MassIndexerProgressMonitor progressMonitor) {
        return new DefaultBatchBackend(this, progressMonitor);
    }

    @Override
    public TypeHierarchy getConfiguredTypeHierarchy() {
        return this.configuredTypeHierarchy;
    }

    @Override
    public TypeHierarchy getIndexedTypeHierarchy() {
        return this.indexedTypeHierarchy;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseRetrievalMethod getDefaultDatabaseRetrievalMethod() {
        return this.defaultDatabaseRetrievalMethod;
    }

    @Override
    public ObjectLookupMethod getDefaultObjectLookupMethod() {
        return this.defaultObjectLookupMethod;
    }

    @Override
    public ExtendedSearchIntegrator getUninitializedSearchIntegrator() {
        return this;
    }

    @Override
    public boolean isJMXEnabled() {
        String enableJMX = this.getConfigurationProperties().getProperty("hibernate.search.jmx_enabled");
        return "true".equalsIgnoreCase(enableJMX);
    }

    private String registerMBeans() {
        String mbeanNameSuffix = this.getConfigurationProperties().getProperty("hibernate.search.jmx_bean_suffix");
        String objectName = JMXRegistrar.buildMBeanName("org.hibernate.search.jmx:type=StatisticsInfoMBean", mbeanNameSuffix);
        if (JMXRegistrar.isNameRegistered(objectName)) {
            JMXRegistrar.unRegisterMBean(objectName);
        }
        JMXRegistrar.StatisticsInfo statisticsInfo = new JMXRegistrar.StatisticsInfo(this.statistics);
        JMXRegistrar.registerMBean(statisticsInfo, StatisticsInfoMBean.class, objectName);
        return objectName;
    }

    @Override
    public boolean isDirtyChecksEnabled() {
        return this.enableDirtyChecks;
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return this.transactionManagerExpected;
    }

    @Override
    public IndexManagerHolder getAllIndexesManager() {
        return this.getIndexManagerHolder();
    }

    @Override
    public IndexManagerHolder getIndexManagerHolder() {
        return this.allIndexesManager;
    }

    @Deprecated
    public EntityIndexBinding getSafeIndexBindingForEntity(Class<?> entityType) {
        if (entityType == null) {
            throw log.nullIsInvalidIndexedType();
        }
        EntityIndexBinding entityIndexBinding = this.getIndexBindings().get(entityType);
        if (entityIndexBinding == null) {
            throw log.notAnIndexedType(entityType.getName());
        }
        return entityIndexBinding;
    }

    public EntityIndexBinding getSafeIndexBindingForEntity(IndexedTypeIdentifier type) {
        if (type == null) {
            throw log.nullIsInvalidIndexedType();
        }
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(type);
        if (entityIndexBinding == null) {
            throw log.notAnIndexedType(type.getName());
        }
        return entityIndexBinding;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public IndexReaderAccessor getIndexReaderAccessor() {
        return this.indexReaderAccessor;
    }

    @Override
    public IndexedTypeDescriptor getIndexedTypeDescriptor(IndexedTypeIdentifier type) {
        IndexedTypeDescriptor typeDescriptor = this.indexedTypeDescriptors.get(type);
        if (typeDescriptor == null) {
            EntityIndexBinding indexBinder = this.indexBindingForEntities.get(type);
            IndexedTypeDescriptor indexedTypeDescriptor = indexBinder == null ? new IndexedTypeDescriptorForUnindexedType(type) : new IndexedTypeDescriptorImpl(indexBinder.getDocumentBuilder().getTypeMetadata(), indexBinder.getIndexManagerSelector().all());
            this.indexedTypeDescriptors.put(type, indexedTypeDescriptor);
            typeDescriptor = indexedTypeDescriptor;
        }
        return typeDescriptor;
    }

    @Override
    public IndexedTypeSet getIndexedTypeIdentifiers() {
        return this.indexBindingForEntities.keySet();
    }

    @Override
    public InstanceInitializer getInstanceInitializer() {
        return this.instanceInitializer;
    }

    @Override
    public TimeoutExceptionFactory getDefaultTimeoutExceptionFactory() {
        return this.timeoutExceptionFactory;
    }

    @Override
    public TimingSource getTimingSource() {
        return this.timingSource;
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return this.mapping;
    }

    @Override
    public boolean isIndexMetadataComplete() {
        return this.indexMetadataIsComplete;
    }

    @Override
    public boolean isDeleteByTermEnforced() {
        return this.isDeleteByTermEnforced;
    }

    @Override
    public boolean isIdProvidedImplicit() {
        return this.isIdProvidedImplicit;
    }

    @Override
    public boolean isMultitenancyEnabled() {
        return this.isMultitenancyEnabled;
    }

    @Override
    public IndexManagerFactory getIndexManagerFactory() {
        return this.indexManagerFactory;
    }

    @Override
    public boolean enlistWorkerInTransaction() {
        return this.enlistWorkerInTransaction;
    }

    @Override
    public IndexFamily getIndexFamily(IndexFamilyType indexFamilyType) {
        SearchIntegration integration = this.integrations.get(indexFamilyType);
        if (integration != null) {
            return integration.getIndexFamily();
        }
        return null;
    }

    @Override
    public IndexManager getIndexManager(String indexName) {
        return this.getIndexManagerHolder().getIndexManager(indexName);
    }

    @Override
    public boolean isIndexUninvertingAllowed() {
        return this.indexUninvertingAllowed;
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (SearchIntegrator.class.isAssignableFrom(cls) || ExtendedSearchIntegrator.class.isAssignableFrom(cls) || SearchFactoryState.class.isAssignableFrom(cls)) {
            return (T)this;
        }
        throw new SearchException("Can not unwrap an ImmutableSearchFactory into a '" + cls + "'");
    }

    @Override
    public LuceneWorkSerializer getWorkSerializer() {
        if (this.workSerializer == null) {
            this.workSerializer = this.serviceManager.requestService(LuceneWorkSerializer.class);
        }
        return this.workSerializer;
    }

    @Override
    public LuceneWorkSerializer getWorkSerializerState() {
        return this.workSerializer;
    }

    @Override
    public OperationDispatcher createRemoteOperationDispatcher(Predicate<IndexManager> predicate) {
        return new TransactionalOperationDispatcher(this, predicate);
    }

    static {
        Version.touch();
        log = LoggerFactory.make(MethodHandles.lookup());
    }
}

