/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging;

import com.arjuna.schemas.ws._2005._10.wsarjtx.NotificationType;
import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.base.processors.ActivatedObjectProcessor;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices.wsarjtx.ArjunaTXConstants;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsarjtx.client.TerminationParticipantClient;
import com.arjuna.webservices11.wsarjtx.processors.TerminationCoordinatorProcessor;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst11.BusinessActivityTerminator;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;

public class TerminationCoordinatorProcessorImpl
extends TerminationCoordinatorProcessor {
    private final ActivatedObjectProcessor activatedObjectProcessor = new ActivatedObjectProcessor();

    @Override
    public void activateParticipant(BusinessActivityTerminator participant, String identifier) {
        this.activatedObjectProcessor.activateObject(participant, identifier);
    }

    @Override
    public void deactivateParticipant(BusinessActivityTerminator participant) {
        this.activatedObjectProcessor.deactivateObject(participant);
    }

    @Override
    public BusinessActivityTerminator getParticipant(InstanceIdentifier instanceIdentifier) {
        String identifier = instanceIdentifier != null ? instanceIdentifier.getInstanceIdentifier() : null;
        return (BusinessActivityTerminator)this.activatedObjectProcessor.getObject(identifier);
    }

    @Override
    public void cancel(NotificationType cancel, MAP map, ArjunaContext arjunaContext) {
        block10: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            BusinessActivityTerminator participant = this.getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    W3CEndpointReference endpoint = participant.getEndpoint();
                    String messageId = MessageId.getMessageId();
                    try {
                        participant.cancel();
                    }
                    catch (FaultedException fe) {
                        MAP responseMAP = AddressingHelper.createNotificationContext(messageId);
                        TerminationParticipantClient.getClient().sendFaulted(endpoint, responseMAP, instanceIdentifier);
                    }
                    catch (UnknownTransactionException ute) {
                        MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_1());
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    catch (SystemException se) {
                        MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                        String message = WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_2();
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME, message);
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev("Unexpected exception thrown from cancel:", (Object)th);
                        }
                        MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                        SoapFault11 soapFault = new SoapFault11(th);
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    MAP responseMAP = AddressingHelper.createNotificationContext(messageId);
                    TerminationParticipantClient.getClient().sendCancelled(endpoint, responseMAP, instanceIdentifier);
                    break block10;
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Cancel called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                MAP faultMAP = AddressingHelper.createFaultContext(map, MessageId.getMessageId());
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_5());
                TerminationParticipantClient.getClient().sendSoapFault(soapFault, faultMAP, instanceIdentifier);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void close(NotificationType close, MAP map, ArjunaContext arjunaContext) {
        block10: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            BusinessActivityTerminator participant = this.getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    W3CEndpointReference endpoint = participant.getEndpoint();
                    String messageId = MessageId.getMessageId();
                    try {
                        participant.close();
                    }
                    catch (UnknownTransactionException ute) {
                        MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_6());
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    catch (TransactionRolledBackException trbe) {
                        MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.TRANSACTIONROLLEDBACK_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_7());
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    catch (SystemException se) {
                        MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                        String message = WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_8();
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME, message);
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev("Unexpected exception thrown from close:", (Object)th);
                        }
                        MAP faultMAP = AddressingHelper.createFaultContext(map, MessageId.getMessageId());
                        SoapFault11 soapFault = new SoapFault11(th);
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    MAP responseMAP = AddressingHelper.createNotificationContext(messageId);
                    TerminationParticipantClient.getClient().sendClosed(endpoint, responseMAP, instanceIdentifier);
                    break block10;
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Close called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                MAP faultMAP = AddressingHelper.createFaultContext(map, MessageId.getMessageId());
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_11());
                TerminationParticipantClient.getClient().sendSoapFault(soapFault, faultMAP, instanceIdentifier);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void complete(NotificationType complete, MAP map, ArjunaContext arjunaContext) {
        block10: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            BusinessActivityTerminator participant = this.getParticipant(instanceIdentifier);
            try {
                if (participant != null) {
                    W3CEndpointReference endpoint = participant.getEndpoint();
                    String messageId = MessageId.getMessageId();
                    try {
                        participant.complete();
                    }
                    catch (FaultedException fe) {
                        MAP responseMAP = AddressingHelper.createNotificationContext(messageId);
                        TerminationParticipantClient.getClient().sendFaulted(endpoint, responseMAP, instanceIdentifier);
                    }
                    catch (UnknownTransactionException ute) {
                        MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_12());
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    catch (SystemException se) {
                        MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                        String message = WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_13();
                        SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNERROR_ERROR_CODE_QNAME, message);
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    catch (Throwable th) {
                        if (WSTLogger.logger.isTraceEnabled()) {
                            WSTLogger.logger.tracev("Unexpected exception thrown from complete:", (Object)th);
                        }
                        MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
                        SoapFault11 soapFault = new SoapFault11(th);
                        TerminationParticipantClient.getClient().sendSoapFault(endpoint, faultMAP, soapFault, instanceIdentifier);
                        return;
                    }
                    MAP responseMAP = AddressingHelper.createNotificationContext(messageId);
                    TerminationParticipantClient.getClient().sendCompleted(endpoint, responseMAP, instanceIdentifier);
                    break block10;
                }
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Complete called on unknown participant: {0}", new Object[]{instanceIdentifier});
                }
                MAP faultMAP = AddressingHelper.createFaultContext(map, MessageId.getMessageId());
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_TerminationCoordinatorProcessorImpl_16());
                TerminationParticipantClient.getClient().sendSoapFault(soapFault, faultMAP, instanceIdentifier);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void soapFault(SoapFault soapFault, MAP map, ArjunaContext arjunaContext) {
        if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Service {0} received unexpected fault: {1}", new Object[]{"TerminationCoordinator", soapFault});
        }
    }
}

