/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.jboss.as.controller.AttributeDefinition;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ConnectionFactoryAttribute {
    private final AttributeDefinition attributeDefinition;
    private String propertyName;
    private final boolean resourceAdapterProperty;
    private ConfigType configType;

    public static ConnectionFactoryAttribute create(AttributeDefinition attributeDefinition, String propertyName, boolean resourceAdapterProperty) {
        return new ConnectionFactoryAttribute(attributeDefinition, propertyName, resourceAdapterProperty, null);
    }

    public static ConnectionFactoryAttribute create(AttributeDefinition attributeDefinition, String propertyName, boolean resourceAdapterProperty, ConfigType inboundConfig) {
        return new ConnectionFactoryAttribute(attributeDefinition, propertyName, resourceAdapterProperty, inboundConfig);
    }

    public static AttributeDefinition[] getDefinitions(ConnectionFactoryAttribute ... attrs) {
        AttributeDefinition[] definitions = new AttributeDefinition[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            ConnectionFactoryAttribute attr = attrs[i];
            definitions[i] = attr.getDefinition();
        }
        return definitions;
    }

    private ConnectionFactoryAttribute(AttributeDefinition attributeDefinition, String propertyName, boolean resourceAdapterProperty, ConfigType configType) {
        this.attributeDefinition = attributeDefinition;
        this.propertyName = propertyName;
        this.resourceAdapterProperty = resourceAdapterProperty;
        this.configType = configType;
    }

    public String getClassType() {
        switch (this.attributeDefinition.getType()) {
            case BOOLEAN: {
                return Boolean.class.getName();
            }
            case BIG_DECIMAL: {
                return Double.class.getName();
            }
            case LONG: {
                return Long.class.getName();
            }
            case INT: {
                return Integer.class.getName();
            }
            case STRING: 
            case LIST: {
                return String.class.getName();
            }
        }
        throw MessagingLogger.ROOT_LOGGER.invalidAttributeType(this.attributeDefinition.getName(), this.attributeDefinition.getType());
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public AttributeDefinition getDefinition() {
        return this.attributeDefinition;
    }

    public boolean isResourceAdapterProperty() {
        return this.resourceAdapterProperty;
    }

    public ConfigType getConfigType() {
        return this.configType;
    }

    static enum ConfigType {
        INBOUND,
        OUTBOUND;

    }
}

