/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.common.util.TransformerUtil;
import org.picketlink.identity.federation.core.util.ProvidersUtil;
import org.picketlink.identity.federation.core.util.SecurityActions;
import org.picketlink.identity.federation.core.util.SignatureUtilTransferObject;
import org.picketlink.identity.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.SignatureType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSignatureUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static String canonicalizationMethodType;
    private static XMLSignatureFactory fac;
    private static boolean includeKeyInfoInSignature;

    private static XMLSignatureFactory getXMLSignatureFactory() {
        XMLSignatureFactory xsf = null;
        try {
            xsf = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
        }
        catch (NoSuchProviderException ex) {
            try {
                xsf = XMLSignatureFactory.getInstance("DOM");
            }
            catch (Exception err) {
                throw new RuntimeException(logger.couldNotCreateInstance("DOM", (Throwable)err));
            }
        }
        return xsf;
    }

    public static void setCanonicalizationMethodType(String canonical) {
        if (canonical != null) {
            canonicalizationMethodType = canonical;
        }
    }

    public static void setIncludeKeyInfoInSignature(boolean includeKeyInfoInSignature) {
        XMLSignatureUtil.includeKeyInfoInSignature = includeKeyInfoInSignature;
    }

    public static boolean preCheckSignedInfo(Document doc) {
        NodeList nl = doc.getElementsByTagNameNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "SignedInfo");
        return nl != null ? nl.getLength() > 0 : false;
    }

    public static Document sign(Document doc, Node parentOfNodeToBeSigned, PrivateKey signingKey, X509Certificate certificate, String digestMethod, String signatureMethod, String referenceURI) throws ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        KeyPair keyPair = new KeyPair(certificate.getPublicKey(), signingKey);
        return XMLSignatureUtil.sign(doc, parentOfNodeToBeSigned, keyPair, digestMethod, signatureMethod, referenceURI);
    }

    public static Document sign(Document doc, Node nodeToBeSigned, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI) throws ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        if (nodeToBeSigned == null) {
            throw logger.nullArgumentError("Node to be signed");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Document to be signed=" + DocumentUtil.asString((Document)doc));
        }
        Node parentNode = nodeToBeSigned.getParentNode();
        Document newDoc = DocumentUtil.createDocument();
        Node signingNode = newDoc.importNode(nodeToBeSigned, true);
        newDoc.appendChild(signingNode);
        if (!referenceURI.isEmpty()) {
            XMLSignatureUtil.propagateIDAttributeSetup(nodeToBeSigned, newDoc.getDocumentElement());
        }
        newDoc = XMLSignatureUtil.sign(newDoc, keyPair, digestMethod, signatureMethod, referenceURI);
        if (nodeToBeSigned.getLocalName().equals("Assertion") && "urn:oasis:names:tc:SAML:2.0:assertion".equals(nodeToBeSigned.getNamespaceURI())) {
            Element signatureNode = DocumentUtil.getElement((Document)newDoc, (QName)new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"));
            Element subjectNode = DocumentUtil.getElement((Document)newDoc, (QName)new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Subject"));
            if (signatureNode != null && subjectNode != null) {
                newDoc.getDocumentElement().removeChild(signatureNode);
                newDoc.getDocumentElement().insertBefore(signatureNode, subjectNode);
            }
        }
        Node signedNode = doc.importNode(newDoc.getFirstChild(), true);
        if (!referenceURI.isEmpty()) {
            XMLSignatureUtil.propagateIDAttributeSetup(newDoc.getDocumentElement(), (Element)signedNode);
        }
        parentNode.replaceChild(signedNode, nodeToBeSigned);
        return doc;
    }

    public static Document sign(Document doc, Node nodeToBeSigned, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI, X509Certificate x509Certificate) throws ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        if (nodeToBeSigned == null) {
            throw logger.nullArgumentError("Node to be signed");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Document to be signed=" + DocumentUtil.asString((Document)doc));
        }
        Node parentNode = nodeToBeSigned.getParentNode();
        Document newDoc = DocumentUtil.createDocument();
        Node signingNode = newDoc.importNode(nodeToBeSigned, true);
        newDoc.appendChild(signingNode);
        if (!referenceURI.isEmpty()) {
            XMLSignatureUtil.propagateIDAttributeSetup(nodeToBeSigned, newDoc.getDocumentElement());
        }
        newDoc = XMLSignatureUtil.sign(newDoc, keyPair, digestMethod, signatureMethod, referenceURI, x509Certificate);
        if (nodeToBeSigned.getLocalName().equals("Assertion") && "urn:oasis:names:tc:SAML:2.0:assertion".equals(nodeToBeSigned.getNamespaceURI())) {
            Element signatureNode = DocumentUtil.getElement((Document)newDoc, (QName)new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"));
            Element subjectNode = DocumentUtil.getElement((Document)newDoc, (QName)new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Subject"));
            if (signatureNode != null && subjectNode != null) {
                newDoc.getDocumentElement().removeChild(signatureNode);
                newDoc.getDocumentElement().insertBefore(signatureNode, subjectNode);
            }
        }
        Node signedNode = doc.importNode(newDoc.getFirstChild(), true);
        if (!referenceURI.isEmpty()) {
            XMLSignatureUtil.propagateIDAttributeSetup(newDoc.getDocumentElement(), (Element)signedNode);
        }
        parentNode.replaceChild(signedNode, nodeToBeSigned);
        return doc;
    }

    public static void sign(Element elementToSign, Node nextSibling, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        XMLSignatureUtil.sign(elementToSign, nextSibling, keyPair, digestMethod, signatureMethod, referenceURI, null);
    }

    public static void sign(Element elementToSign, Node nextSibling, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI, X509Certificate x509Certificate) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        PrivateKey signingKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        DOMSignContext dsc = new DOMSignContext(signingKey, (Node)elementToSign, nextSibling);
        XMLSignatureUtil.signImpl(dsc, digestMethod, signatureMethod, referenceURI, publicKey, x509Certificate);
    }

    public static void propagateIDAttributeSetup(Node sourceNode, Element destElement) {
        NamedNodeMap nnm = sourceNode.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr attr = (Attr)nnm.item(i);
            if (!attr.isId()) continue;
            destElement.setIdAttribute(attr.getName(), true);
            break;
        }
    }

    public static Document sign(Document doc, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        return XMLSignatureUtil.sign(doc, keyPair, digestMethod, signatureMethod, referenceURI, null);
    }

    public static Document sign(Document doc, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI, X509Certificate x509Certificate) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        logger.trace("Document to be signed=" + DocumentUtil.asString((Document)doc));
        PrivateKey signingKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        DOMSignContext dsc = new DOMSignContext(signingKey, (Node)doc.getDocumentElement());
        XMLSignatureUtil.signImpl(dsc, digestMethod, signatureMethod, referenceURI, publicKey, x509Certificate);
        return doc;
    }

    public static Document sign(SignatureUtilTransferObject dto) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        Document doc = dto.getDocumentToBeSigned();
        KeyPair keyPair = dto.getKeyPair();
        Node nextSibling = dto.getNextSibling();
        String digestMethod = dto.getDigestMethod();
        String referenceURI = dto.getReferenceURI();
        String signatureMethod = dto.getSignatureMethod();
        logger.trace("Document to be signed=" + DocumentUtil.asString((Document)doc));
        PrivateKey signingKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        DOMSignContext dsc = new DOMSignContext(signingKey, (Node)doc.getDocumentElement(), nextSibling);
        XMLSignatureUtil.signImpl(dsc, digestMethod, signatureMethod, referenceURI, publicKey, dto.getX509Certificate());
        return doc;
    }

    public static boolean validate(Document signedDoc, Key publicKey) throws MarshalException, XMLSignatureException {
        if (signedDoc == null) {
            throw logger.nullArgumentError("Signed Document");
        }
        XMLSignatureUtil.propagateIDAttributeSetup(signedDoc.getDocumentElement(), signedDoc.getDocumentElement());
        NodeList nl = signedDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl == null || nl.getLength() == 0) {
            throw logger.nullValueError("Cannot find Signature element");
        }
        if (publicKey == null) {
            throw logger.nullValueError("Public Key");
        }
        int signedAssertions = 0;
        String assertionNameSpaceUri = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            DOMValidateContext valContext;
            XMLSignature signature;
            boolean coreValidity;
            Node signatureNode = nl.item(i);
            Node parent = signatureNode.getParentNode();
            if (parent != null && JBossSAMLConstants.ASSERTION.get().equals(parent.getLocalName())) {
                ++signedAssertions;
                if (assertionNameSpaceUri == null) {
                    assertionNameSpaceUri = parent.getNamespaceURI();
                }
            }
            if (coreValidity = (signature = fac.unmarshalXMLSignature(valContext = new DOMValidateContext(publicKey, signatureNode))).validate(valContext)) continue;
            if (logger.isTraceEnabled()) {
                boolean sv = signature.getSignatureValue().validate(valContext);
                logger.trace("Signature validation status: " + sv);
                List<Reference> references = signature.getSignedInfo().getReferences();
                for (Reference ref : references) {
                    logger.trace("[Ref id=" + ref.getId() + ":uri=" + ref.getURI() + "]validity status:" + ref.validate(valContext));
                }
            }
            return false;
        }
        NodeList assertions = signedDoc.getElementsByTagNameNS(assertionNameSpaceUri, JBossSAMLConstants.ASSERTION.get());
        return signedAssertions <= 0 || assertions == null || assertions.getLength() == signedAssertions;
    }

    public static void marshall(SignatureType signature, OutputStream os) throws JAXBException, SAXException {
        throw logger.notImplementedYet("NYI");
    }

    public static void marshall(Document signedDocument, OutputStream os) throws TransformerException {
        TransformerFactory tf = TransformerUtil.getTransformerFactory();
        Transformer trans = tf.newTransformer();
        trans.transform(DocumentUtil.getXMLSource((Document)signedDocument), new StreamResult(os));
    }

    public static X509Certificate getX509CertificateFromKeyInfoString(String certificateString) throws ProcessingException {
        X509Certificate cert = null;
        StringBuilder builder = new StringBuilder();
        builder.append("-----BEGIN CERTIFICATE-----\n").append(certificateString).append("\n-----END CERTIFICATE-----");
        String derFormattedString = builder.toString();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(derFormattedString.getBytes());
            while (bais.available() > 0) {
                cert = (X509Certificate)cf.generateCertificate(bais);
            }
        }
        catch (CertificateException e) {
            throw logger.processingError((Throwable)e);
        }
        return cert;
    }

    public static DSAKeyValueType getDSAKeyValue(Element element) throws ParsingException {
        DSAKeyValueType dsa = new DSAKeyValueType();
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String tag = childElement.getLocalName();
            byte[] text = childElement.getTextContent().getBytes();
            if ("P".equals(tag)) {
                dsa.setP(text);
                continue;
            }
            if ("Q".equals(tag)) {
                dsa.setQ(text);
                continue;
            }
            if ("G".equals(tag)) {
                dsa.setG(text);
                continue;
            }
            if ("Y".equals(tag)) {
                dsa.setY(text);
                continue;
            }
            if ("Seed".equals(tag)) {
                dsa.setSeed(text);
                continue;
            }
            if (!"PgenCounter".equals(tag)) continue;
            dsa.setPgenCounter(text);
        }
        return dsa;
    }

    public static RSAKeyValueType getRSAKeyValue(Element element) throws ParsingException {
        RSAKeyValueType rsa = new RSAKeyValueType();
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String tag = childElement.getLocalName();
            byte[] text = childElement.getTextContent().getBytes();
            if ("Modulus".equals(tag)) {
                rsa.setModulus(text);
                continue;
            }
            if (!"Exponent".equals(tag)) continue;
            rsa.setExponent(text);
        }
        return rsa;
    }

    public static KeyValueType createKeyValue(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey pubKey = (RSAPublicKey)key;
            byte[] modulus = pubKey.getModulus().toByteArray();
            byte[] exponent = pubKey.getPublicExponent().toByteArray();
            RSAKeyValueType rsaKeyValue = new RSAKeyValueType();
            rsaKeyValue.setModulus(Base64.encodeBytes((byte[])modulus).getBytes());
            rsaKeyValue.setExponent(Base64.encodeBytes((byte[])exponent).getBytes());
            return rsaKeyValue;
        }
        if (key instanceof DSAPublicKey) {
            DSAPublicKey pubKey = (DSAPublicKey)key;
            byte[] P = pubKey.getParams().getP().toByteArray();
            byte[] Q = pubKey.getParams().getQ().toByteArray();
            byte[] G = pubKey.getParams().getG().toByteArray();
            byte[] Y = pubKey.getY().toByteArray();
            DSAKeyValueType dsaKeyValue = new DSAKeyValueType();
            dsaKeyValue.setP(Base64.encodeBytes((byte[])P).getBytes());
            dsaKeyValue.setQ(Base64.encodeBytes((byte[])Q).getBytes());
            dsaKeyValue.setG(Base64.encodeBytes((byte[])G).getBytes());
            dsaKeyValue.setY(Base64.encodeBytes((byte[])Y).getBytes());
            return dsaKeyValue;
        }
        throw logger.unsupportedType(key.toString());
    }

    private static void signImpl(DOMSignContext dsc, String digestMethod, String signatureMethod, String referenceURI, PublicKey publicKey, X509Certificate x509Certificate) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        dsc.setDefaultNamespacePrefix("dsig");
        DigestMethod digestMethodObj = fac.newDigestMethod(digestMethod, null);
        Transform transform1 = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        Transform transform2 = fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        transformList.add(transform1);
        transformList.add(transform2);
        Reference ref = fac.newReference(referenceURI, digestMethodObj, transformList, null, null);
        CanonicalizationMethod canonicalizationMethod = fac.newCanonicalizationMethod(canonicalizationMethodType, (C14NMethodParameterSpec)null);
        List<Reference> referenceList = Collections.singletonList(ref);
        SignatureMethod signatureMethodObj = fac.newSignatureMethod(signatureMethod, null);
        SignedInfo si = fac.newSignedInfo(canonicalizationMethod, signatureMethodObj, referenceList);
        KeyInfo ki = null;
        if (includeKeyInfoInSignature) {
            ki = XMLSignatureUtil.createKeyInfo(publicKey, x509Certificate);
        }
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
    }

    private static KeyInfo createKeyInfo(PublicKey publicKey, X509Certificate x509Certificate) throws KeyException {
        KeyInfoFactory keyInfoFactory = fac.getKeyInfoFactory();
        KeyInfo keyInfo = null;
        KeyValue keyValue = null;
        if (publicKey != null) {
            keyValue = keyInfoFactory.newKeyValue(publicKey);
            keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValue));
        }
        if (x509Certificate != null) {
            ArrayList<X509Certificate> x509list = new ArrayList<X509Certificate>();
            x509list.add(x509Certificate);
            X509Data x509Data = keyInfoFactory.newX509Data(x509list);
            ArrayList<XMLStructure> items = new ArrayList<XMLStructure>();
            items.add(x509Data);
            if (keyValue != null) {
                items.add(keyValue);
            }
            keyInfo = keyInfoFactory.newKeyInfo(items);
        }
        return keyInfo;
    }

    static {
        ProvidersUtil.ensure();
        SystemPropertiesUtil.ensure();
        String keyInfoProp = SecurityActions.getSystemProperty("picketlink.xmlsig.includeKeyInfo", null);
        if (StringUtil.isNotNull((String)keyInfoProp)) {
            includeKeyInfoInSignature = Boolean.parseBoolean(keyInfoProp);
        }
        canonicalizationMethodType = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
        fac = XMLSignatureUtil.getXMLSignatureFactory();
        includeKeyInfoInSignature = true;
    }
}

