/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.wildfly.security.keystore.DelegatingKeyStoreSpi;

class ModifyTrackingKeyStoreSpi
extends DelegatingKeyStoreSpi {
    private final KeyStore delegate;
    private volatile boolean initialised = false;
    private volatile boolean modified = false;

    ModifyTrackingKeyStoreSpi(KeyStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        super.engineSetKeyEntry(alias, key, password, chain);
        this.modified = true;
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        super.engineSetKeyEntry(alias, key, chain);
        this.modified = true;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        super.engineSetCertificateEntry(alias, cert);
        this.modified = true;
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        super.engineDeleteEntry(alias);
        this.modified = true;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        super.engineStore(stream, password);
        this.modified = false;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (this.initialised) {
            super.engineLoad(stream, password);
            this.modified = false;
        } else {
            this.initialised = true;
        }
    }

    boolean isModified() {
        return this.modified;
    }

    void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    protected KeyStore getKeyStore() {
        return this.delegate;
    }
}

