/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

class CandidatesProviders {
    static final DefaultCompleter.CandidatesProvider HOSTS = new DefaultCompleter.CandidatesProvider(){

        public Collection<String> getAllCandidates(CommandContext ctx) {
            ModelControllerClient client = ctx.getModelControllerClient();
            ModelNode address = new ModelNode().setEmptyList();
            return CandidatesProviders.getChildrenNames(client, address, "host");
        }
    };

    CandidatesProviders() {
    }

    private static Collection<String> getChildrenNames(ModelControllerClient client, ModelNode address, String childType) {
        ModelNode response;
        if (client == null) {
            return Collections.emptyList();
        }
        ModelNode request = new ModelNode();
        request.get("address").set(address);
        request.get("operation").set("read-children-names");
        request.get("child-type").set(childType);
        try {
            response = client.execute(request);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            return Collections.emptyList();
        }
        List list = result.asList();
        ArrayList<String> names = new ArrayList<String>(list.size());
        for (ModelNode node : list) {
            names.add(node.asString());
        }
        return names;
    }

    static final DefaultCompleter.CandidatesProvider newServerCandidatesProvider(final ArgumentWithValue host) {
        return new DefaultCompleter.CandidatesProvider(){

            public Collection<String> getAllCandidates(CommandContext ctx) {
                ModelControllerClient client = ctx.getModelControllerClient();
                ModelNode address = new ModelNode().set("host", host.getValue(ctx.getParsedCommandLine()));
                return CandidatesProviders.getChildrenNames(client, address, "server");
            }
        };
    }
}

