/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.File;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchMetadataResolver;
import org.jboss.as.patching.metadata.PatchXml;
import org.jboss.as.patching.validation.AbstractArtifact;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.as.patching.validation.PatchingArtifactProcessor;
import org.jboss.as.patching.validation.PatchingArtifactValidationContext;
import org.jboss.as.patching.validation.PatchingFileArtifact;

class PatchingXmlArtifact<E extends Patch>
extends AbstractArtifact<PatchingFileArtifact.FileArtifactState, XmlArtifactState<E>> {
    PatchingXmlArtifact(PatchingArtifact<XmlArtifactState<E>, ? extends PatchingArtifact.ArtifactState> ... artifacts) {
        super(artifacts);
    }

    @Override
    public boolean process(PatchingFileArtifact.FileArtifactState parent, PatchingArtifactProcessor processor) {
        File xmlFile = parent.getFile();
        XmlArtifactState state = new XmlArtifactState(xmlFile, this);
        return processor.process(this, state);
    }

    protected E resolveMetaData(PatchMetadataResolver resolver) throws PatchingException {
        throw new IllegalStateException();
    }

    static class XmlArtifactState<E extends Patch>
    implements PatchingArtifact.ArtifactState {
        private final File xmlFile;
        private final PatchingXmlArtifact<E> artifact;
        private E patch;

        XmlArtifactState(File xmlFile, PatchingXmlArtifact<E> artifact) {
            this.xmlFile = xmlFile;
            this.artifact = artifact;
        }

        public E getPatch() {
            return this.patch;
        }

        @Override
        public boolean isValid(PatchingArtifactValidationContext context) {
            if (this.patch != null) {
                return true;
            }
            try {
                PatchMetadataResolver resolver = PatchXml.parse(this.xmlFile, context.getInstalledIdentity());
                this.patch = this.artifact.resolveMetaData(resolver);
                return true;
            }
            catch (Exception e) {
                context.getErrorHandler().addError(this.artifact, this);
                return false;
            }
        }

        public String toString() {
            return this.xmlFile.getAbsolutePath();
        }
    }
}

