/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.api.example;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.api.Client;
import cz.cesnet.cloud.occi.api.EntityBuilder;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.exception.EntityBuildingException;
import cz.cesnet.cloud.occi.api.http.HTTPClient;
import cz.cesnet.cloud.occi.api.http.auth.X509Authentication;
import cz.cesnet.cloud.occi.core.ActionInstance;
import cz.cesnet.cloud.occi.core.Entity;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.AmbiguousIdentifierException;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.exception.RenderingException;
import java.net.URI;
import java.util.List;

public class AdvancedUsageExample {
    public static void main(String[] args) {
        try {
            X509Authentication authentication = new X509Authentication("/path/to/certificate.pem", "password");
            authentication.setCAPath("/path/to/certificate/directory");
            HTTPClient client = new HTTPClient(URI.create("https://localhost:1234"), authentication, "text/plain", false);
            ((Client)client).connect();
            System.out.println("Listing resources...");
            List<URI> list = ((Client)client).list();
            System.out.println("Locations:");
            for (URI uri : list) {
                System.out.println(uri);
            }
            System.out.println("Creating compute resource...");
            Model model = client.getModel();
            EntityBuilder eb = new EntityBuilder(model);
            System.out.println("Listing available os template mixins...");
            List mixins = model.findRelatedMixins("os_tpl");
            if (mixins.isEmpty()) {
                System.err.println("No os template mixins available. Quiting.");
                return;
            }
            Resource compute = eb.getResource("compute");
            Mixin mixin = (Mixin)mixins.get(0);
            System.out.println("Mixin:");
            System.out.println(mixin.toText());
            compute.addMixin((Mixin)mixins.get(0));
            compute.addAttribute("occi.compute.architecture", "x86");
            compute.addAttribute("occi.compute.cores", "2");
            compute.addAttribute("occi.compute.hostname", "jocci-test");
            compute.addAttribute("occi.compute.memory", "2");
            URI location = ((Client)client).create((Entity)compute);
            System.out.println("Created compute instance at location: '" + location + "'.");
            List<Entity> entities = ((Client)client).describe(location, new String[0]);
            System.out.println("Description:");
            System.out.println(entities.get(0).toText());
            System.out.println("Waiting for compute to become active...");
            for (int i = 0; i < 5; ++i) {
                entities = ((Client)client).describe(location, new String[0]);
                if (entities.get(0).getValue("occi.compute.state").equals("active")) {
                    System.out.println("Compute active.");
                    break;
                }
                System.out.println(".");
                Thread.sleep(5000L);
            }
            System.out.println("Stopping previously created compute...");
            ActionInstance actionInstance = eb.getActionInstance(URI.create("http://schemas.ogf.org/occi/infrastructure/compute/action#stop"));
            boolean status = ((Client)client).trigger(location, actionInstance);
            if (status) {
                System.out.println("Triggered: OK");
            } else {
                System.out.println("Triggered: FAIL");
            }
            System.out.println("Starting previously created compute...");
            actionInstance = eb.getActionInstance(URI.create("http://schemas.ogf.org/occi/infrastructure/compute/action#start"));
            status = ((Client)client).trigger(location, actionInstance);
            if (status) {
                System.out.println("Triggered: OK");
            } else {
                System.out.println("Triggered: FAIL");
            }
            System.out.println("Deleting previously created compute...");
            status = ((Client)client).delete(location);
            if (status) {
                System.out.println("Deleted: OK");
            } else {
                System.out.println("Deleted: FAIL");
            }
        }
        catch (CommunicationException | EntityBuildingException | AmbiguousIdentifierException | InvalidAttributeValueException | RenderingException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

