/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.LRUCache;
import tecgraf.openbus.core.v2_0.OctetSeqHolder;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;

class LoginCache {
    private Map<String, LoginEntry> logins;

    LoginCache(int cacheSize) {
        this.logins = Collections.synchronizedMap(new LRUCache(cacheSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateLogin(String loginId, ConnectionImpl conn) throws ServiceFailure {
        long time;
        LoginEntry entry = this.logins.get(loginId);
        if (entry != null) {
            Map<String, LoginEntry> map = this.logins;
            synchronized (map) {
                time = System.currentTimeMillis();
                Long elapsed = (time - entry.lastTime) / 1000L;
                if (elapsed.intValue() <= entry.validity) {
                    return true;
                }
            }
        }
        String busid = conn.busid();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(loginId);
        time = System.currentTimeMillis();
        int validity = conn.logins().getLoginValidity(loginId);
        Map<String, LoginEntry> map = this.logins;
        synchronized (map) {
            LoginEntry loginEntry = this.logins.get(loginId);
            if (loginEntry == null) {
                loginEntry = new LoginEntry();
                loginEntry.loginId = loginId;
                loginEntry.busId = busid;
                loginEntry.lastTime = time;
                loginEntry.validity = validity;
                this.logins.put(loginId, loginEntry);
            } else if (loginEntry.lastTime < time) {
                loginEntry.lastTime = time;
                loginEntry.validity = validity;
            } else {
                validity = loginEntry.validity;
            }
        }
        return validity > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLoginEntity(String loginId, OctetSeqHolder pubkey, ConnectionImpl conn) throws InvalidLogins, ServiceFailure {
        LoginEntry entry = this.logins.get(loginId);
        if (entry != null) {
            Map<String, LoginEntry> map = this.logins;
            synchronized (map) {
                if (entry.entity != null) {
                    pubkey.value = entry.pubkey;
                    return entry.entity;
                }
            }
        }
        LoginInfo info = conn.logins().getLoginInfo(loginId, pubkey);
        Map<String, LoginEntry> map = this.logins;
        synchronized (map) {
            entry = this.logins.get(loginId);
            if (entry == null) {
                entry = new LoginEntry();
                entry.busId = conn.busid();
                entry.loginId = info.id;
                entry.entity = info.entity;
                entry.pubkey = pubkey.value;
                entry.lastTime = System.currentTimeMillis();
                entry.validity = 0;
                this.logins.put(loginId, entry);
                return entry.entity;
            }
            entry.entity = info.entity;
            entry.pubkey = pubkey.value;
            return entry.entity;
        }
    }

    public void clear() {
        this.logins.clear();
    }

    private class LoginEntry {
        public String loginId;
        public String busId;
        public Integer validity;
        public Long lastTime;
        public String entity;
        public byte[] pubkey;

        private LoginEntry() {
        }
    }
}

