package tecgraf.openbus;

import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;

/**
 * Cadeia de chamadas oriundas de um barramento.
 * <p>
 * Coleo de informaes dos logins que originaram chamadas em cadeia atravs
 * de um barramento. Cadeias de chamadas representam chamadas aninhadas dentro
 * do barramento e so teis para que os sistemas que recebam essas chamadas
 * possam identificar se a chamada foi originada por entidades autorizadas ou
 * no.
 * 
 * @author Tecgraf
 */
public interface CallerChain {

  /**
   * Recupera o identificador do barramento atravs do qual essas chamadas foram
   * originadas.
   * 
   * @return Identificador do barramento.
   */
  String busid();

  /**
   * Recupera entidade para o qual a chamada estava destinada. S  possvel
   * fazer chamadas dentro dessa cadeia (atravs do mtodo joinChain da
   * interface {@link OpenBusContext}) se a entidade da conexo corrente for o
   * mesmo do target.
   * <p>
   * No caso de conexes legadas, este campo conter o nome da entidade da
   * conexo que atendeu (validou) a requisio. Todas as chamadas feitas como
   * parte de uma cadeia de uma chamada legada sero feitas utilizando apenas o
   * protocolo do OpenBus 1.5 (apenas com credenciais legadas) e portanto sero
   * recusadas por servios que no aceitem chamadas legadas (OpenBus 1.5).
   * 
   * @return Indentificador da entidade para o qual a chamada estava destinada.
   */
  String target();

  /**
   * Recupera a lista de informaes de login de todas as entidades que
   * originaram as chamadas nessa cadeia. Quando essa lista  vazia isso indica
   * que a chamada no est inclusa em outra cadeia de chamadas.
   * 
   * @return lista de logins.
   */
  LoginInfo[] originators();

  /**
   * Recupera a informao de login da entidade que realizou a ltima chamada da
   * cadeia.
   * 
   * @return a informao de login.
   */
  LoginInfo caller();
}
