package tecgraf.openbus.exception;

/**
 * Exceo de configurao de propriedade com valor invlido.
 * 
 * @author Tecgraf
 */
public final class InvalidPropertyValue extends OpenBusException {

  /** Nome da propriedade */
  private String prop;
  /** Valor invlido atribudo */
  private String value;

  /**
   * Construtor.
   * 
   * @param prop nome da propriedade
   * @param value valor invlido atribudo.
   */
  public InvalidPropertyValue(String prop, String value) {
    super(String
      .format("Valor da propriedade '%s'  invlido: %s", prop, value));
    this.prop = prop;
    this.value = value;
  }

  /**
   * Recupera o nome da propriedade.
   * 
   * @return o nome da propriedade.
   */
  public String getProperty() {
    return prop;
  }

  /**
   * Recupera o valor da propriedade.
   * 
   * @return o valor da propriedade.
   */
  public String getValue() {
    return value;
  }
}
