/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.ClockHelper;
import demo.ClockImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.exception.SCSException;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.assistant.AssistantParams;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public final class IndependentClockServer {
    private static String host;
    private static int port;
    private static String entity;
    private static OpenBusPrivateKey privateKey;
    private static int interval;

    public static void main(String[] args) throws InvalidName, AdapterInactive, SCSException, AlreadyLoggedIn, ServiceFailure {
        if (args.length < 4) {
            String params = "[interval]";
            String desc = "\n  - [interval] = Tempo de espera entre tentativas de acesso ao barramento. Valor padr\u00e3o \u00e9 '1'";
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> <privatekeypath> %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - privatekeypath = \u00e9 o caminho da chave privada de autentica\u00e7\u00e3o da entidade %s", params, desc));
            System.exit(1);
            return;
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        entity = args[2];
        String privateKeyFile = args[3];
        try {
            privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
        }
        catch (Exception e) {
            System.out.println("<privatekeypath> deve apontar para uma chave v\u00e1lida.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (args.length > 4) {
            try {
                interval = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException e) {
                System.out.println("Valor de [interval] deve ser um n\u00famero");
                System.exit(1);
                return;
            }
        }
        AssistantParams params = new AssistantParams();
        params.interval = interval;
        final Assistant assist = Assistant.createWithPrivateKey((String)host, (int)port, (String)entity, (PrivateKey)privateKey);
        final ORB orb = assist.orb();
        Thread run = new Thread(){

            @Override
            public void run() {
                orb.run();
            }
        };
        run.start();
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                assist.shutdown();
                orb.shutdown(true);
                orb.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        ComponentId id = new ComponentId("Clock", 1, 0, 0, "java");
        ComponentContext component = new ComponentContext(orb, poa, id);
        final ClockImpl clockImpl = new ClockImpl();
        component.addFacet("Clock", ClockHelper.id(), (Servant)clockImpl);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    Date date = new Date(clockImpl.getTimeInTicks());
                    SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
                    System.out.println(formatter.format(date));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
        ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Independent Clock")};
        assist.registerService(component.getIComponent(), serviceProperties);
    }

    static {
        interval = 1;
    }
}

