package csbase.client.applications.algorithmsmanager.dialogs;

import java.awt.GridBagLayout;

import javax.swing.JLabel;
import javax.swing.JTextField;

import tecgraf.javautils.gui.GBC;
import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;

/**
 * Painel de cabealho com informaes imutveis do algoritmo.
 */
public class AlgorithmStaticInfoPanel extends
  AbstractSimpleApplicationPanel<AlgorithmsManager> {

  /** Campo texto com o nome do algoritmo */
  private JTextField nameText;

  /**
   * Construtor.
   * 
   * @param application a aplicao.
   */
  public AlgorithmStaticInfoPanel(AlgorithmsManager application) {
    super(application);
    buildPanel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void buildPanel() {
    nameText = new JTextField(30);
    nameText.setEditable(false);

    setLayout(new GridBagLayout());
    JLabel nameLabel =
      new JLabel(getString("AlgorithmStaticInfoPanel.label.name"));
    add(nameLabel, new GBC(0, 0).none().west().insets(5, 5, 5, 5));
    add(nameText, new GBC(1, 0).horizontal().west().insets(5, 5, 5, 5));
  }

  /**
   * Define o algoritmo a ser mostrado no painel.
   * 
   * @param algorithm o algoritmo selecionado.
   */
  public void setSelectedAlgorithm(AlgorithmListItem algorithm) {
    String name = null;
    String tooltip = null;
    if (algorithm != null) {
      name = algorithm.getName();
      String id = algorithm.getId();
      tooltip =
        getString("AlgorithmStaticInfoPanel.tooltip.name", new Object[] { id });
    }
    nameText.setText(name);
    nameText.setToolTipText(tooltip);
  }
}
