/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;

import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Ao para remover arquivos executveis.
 */
public class RemoveExecutableFiles extends AbstractVersionTreeNodeAction {

  // Verso que detm os arquivos executveis.
  private final AlgorithmVersionInfo version;
  // Plataforma que detm os arquivos executveis.
  private final String platform;
  // Arquivos executveis a serem removidos.
  private final FileInfo[] files;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso que detm os arquivos executveis.
   * @param platform Plataforma que detm os arquivos executveis.
   * @param files Arquivos a serem removidos.
   */
  public RemoveExecutableFiles(VersionTree tree, AlgorithmVersionInfo version,
    String platform, FileInfo[] files) {
    super(tree, LNG.get("algomanager.menu.bin_file.remove"));

    this.version = version;
    this.platform = platform;
    this.files = files;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    new RemoveExecutableDialog().show();
  }

  /**
   * Classe que representa um dilogo de remoo de executveis.
   * 
   * @author Leonardo Barros
   */
  private class RemoveExecutableDialog {

    /**
     * Exibe o dilogo.
     */
    public void show() {
      String dialogTitle =
        MessageFormat
          .format(LNG.get("algomanager.title.executable"), new Object[] {
              version.getInfo().getName(), version.getId(), platform });
      Object[] options =
        { LNG.get("algomanager.button.remove"),
            LNG.get("algomanager.button.cancel") };
      int opt =
        StandardDialogs.showOptionDialog(getWindow(), dialogTitle,
          MessageFormat.format(
            LNG.get("algomanager.msg.confirm.executable_remove"),
            new Object[] { FormatUtils.format(files) }), options);
      if (opt != 0) {
        return;
      }

      boolean success =
        AlgorithmManagementProxy.removeExecutableFiles(version, platform,
          files, getWindow());
      if (!success) {
        StandardErrorDialogs.showErrorDialog(getWindow(),
          LNG.get("algomanager.title.error") + " - " + dialogTitle,
          MessageFormat.format(LNG.get("algomanager.error.executable_remove"),
            new Object[] { FormatUtils.format(files) }));
      }
    }
  }
}
