package csbase.client.facilities.configurabletable.filter;

import java.util.Map;

import tecgraf.javautils.core.filter.IFilter;

/**
 * Filtro abstrado que pode usar um mapa de parmetros (String -> String) para
 * auxiliar na filtragem dos dados.
 * 
 * @param <T> - Tipo do dado que  filtrado.
 * 
 * @author Tecgraf
 */
public abstract class AbstractFilter<T> implements IFilter<T> {

  /**
   * Parmetros do filtro.
   */
  private Map<String, String> params;

  /**
   * Construtor padro.
   * 
   * @param params - parmetros do filtro.
   */
  protected AbstractFilter(Map<String, String> params) {
    this.params = params;
  }

  /**
   * Retorna os parmetros do filtro.
   * 
   * @return parmetros do filtro.
   */
  public Map<String, String> getParams() {
    return this.params;
  }
}
