/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;

import javax.swing.TransferHandler;
import javax.swing.TransferHandler.TransferSupport;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.VersionTreeClipboard;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.VersionTreeTransferHandler;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Ao que importa dados atravs do {@link VersionTreeTransferHandler
 *         TransferHandler} da rvore.
 */
public class PasteFile extends AbstractVersionTreeNodeAction {

  // Nome padro da ao.
  private static final String DEFAULT_NAME = "paste";

  /**
   * Contri uma instncia de {@link CopyFile} com o nome {@value #DEFAULT_NAME}
   * de {@link DataFlavor} <tt>null</tt>.
   * 
   * @param tree rvore que detm o n fonte da ao.
   */
  public PasteFile(VersionTree tree) {
    this(tree, DEFAULT_NAME, null);
  }

  /**
   * Construtor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param name Nome da aao.
   * @param flavor {@link DataFlavor} dos objetos esperados. Se este valor for
   *        diferente de <tt>null</tt>, o {@link DataFlavor} dos objetos
   *        exportados atravs do {@link VersionTreeTransferHandler
   *        TransferHandler} sero comparados com este e se no forem iguais,
   *        esta ao ser construida desabilitada.
   */
  public PasteFile(VersionTree tree, String name, DataFlavor flavor) {
    super(tree, name);

    if (null != flavor) {
      Transferable transferable = VersionTreeClipboard.getObject();
      setEnabled(null != transferable
        && transferable.isDataFlavorSupported(flavor));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    Transferable transferable = VersionTreeClipboard.getObject();
    if (null != transferable) {
      TransferHandler transferHandler = getTree().getTransferHandler();
      TransferSupport supp = new TransferSupport(getTree(), transferable);
      if (transferHandler.canImport(supp)) {
        transferHandler.importData(supp);
      }
    }
  }
}
