package csbase.client.applications.flowapplication.filters;

import java.awt.geom.Point2D;

import tecgraf.vix.Filter;
import tecgraf.vix.TypeVO;
import tecgraf.vix.TypeVS;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphListener;
import csbase.client.applications.flowapplication.graph.GraphNode;

/**
 * Filtro genrico de workspace
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class WorkspaceFilter extends Filter implements GraphListener {
  /**
   * Workspace
   */
  private final Workspace workspace;

  /**
   * Construtor
   * 
   * @param workspace workspace
   */
  protected WorkspaceFilter(final Workspace workspace) {
    if (workspace == null) {
      throw new IllegalArgumentException("O parmetro workspace est nulo.");
    }
    this.workspace = workspace;
    this.workspace.getGraph().addGraphListener(this);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementParametrized(final Graph graph,
    final GraphElement element) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementCreated(final Graph graph, final GraphElement element) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementDragged(final Graph graph, final GraphElement element,
    final Point2D startPoint, final Point2D endPoint) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementDragged(final Graph graph, final GraphElement element,
    final double tx, final double ty) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementDropped(final Graph graph, final GraphElement element,
    final Point2D point) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(final Graph graph, final GraphElement element) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementSelected(final Graph graph, final GraphElement element) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkAnchored(final Graph graph, final GraphLink link,
    final GraphFileDescriptor fileDescriptor) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkIncreased(final Graph graph, final GraphLink link) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkStatusChanged(final Graph graph, final GraphLink link) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkUnanchored(final Graph graph, final GraphLink link,
    final GraphFileDescriptor fileDescriptor) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasChangedWorkspace(final Graph graph) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasNodeResized(final Graph graph, final GraphNode node) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasParameterSetEnabled(final Graph graph, final GraphNode node,
    final String parameterName, final boolean isEnabled) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasParameterSetVisible(final Graph graph, final GraphNode node,
    final String parameterName, final boolean isVisible) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasReseted(final Graph graph) {
  }

  /**
   * Aplica filtro ao workspace.
   */
  public final void attach() {
    this.workspace.attachFilter(this);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final boolean changeVS(final TypeVS oldVS, final TypeVS newVS) {
    if (super.changeVS(oldVS, newVS)) {
      updateListener();
      return true;
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final boolean changeVO(final TypeVO oldVO, final TypeVO newVO) {
    if (super.changeVO(oldVO, newVO)) {
      updateListener();
      return true;
    }
    return false;
  }

  /**
   * Consulta workspace
   * 
   * @return workspace
   */
  protected final Workspace getWorkspace() {
    return this.workspace;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final void repaint() {
    if (getVS() != null) {
      super.repaint();
    }
  }

  /**
   * Atualiza listener
   */
  private void updateListener() {
    if (getVO() == null || getVS() == null) {
      this.workspace.getGraph().removeGraphListener(this);
    }
    else {
      this.workspace.getGraph().addGraphListener(this);
    }
  }
}
