package csbase.client.applications.serverdiagnostic.monitor;

import csbase.logic.diagnosticservice.Status;

/**
 * Interface de um n da rvore dos status de monitorao.
 * 
 * @author Tecgraf PUC-Rio
 */
public interface StatusTreeNode {

  /**
   * Adiciona um ou mais status como um n filho desse.
   * 
   * @param status o status da monitorao
   * @param renderer o renderizador do painel de detalhes
   * @return o prprio n
   */
  public StatusTreeNode addStatus(Status status, SwingRenderer renderer);

  /**
   * Adiciona um grupamento de status como um n que  filho desse.
   * 
   * @param groupName o nome do grupamento
   * @return o n que representa o grupamento criado
   */
  public StatusTreeNode addStatusGroup(String groupName);
}
