/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.dal;

import java.util.Set;

import csbase.client.applications.commandsmonitor.models.ColumnDTO;
import csbase.client.applications.commandsmonitor.models.CommandsFilterDTO;
import csbase.client.applications.commandsmonitor.models.CommandsTableDTO;

/**
 * Fonte de dados de informaes de tabelas.
 * 
 * @author Tecgraf / PUC-Rio
 */
public interface ICommandsTableDAO {

  /**
   * Obtm o conjunto de informaes de colunas disponveis para se criar uma
   * tabela.
   * 
   * @return conjunto de informaes de colunas disponveis para se criar uma
   *         tabela.
   */
  Set<ColumnDTO> getColumnsInfo();

  /**
   * Obtm o conjunto de informaes de filtros para tabelas.
   * 
   * @return conjunto de informaes de filtros para tabelas.
   */
  Set<CommandsFilterDTO> getFiltersInfo();

  /**
   * Obtm o conjunto de informaes de tabelas.
   * 
   * @return conjunto de informaes de tabelas.
   */
  Set<CommandsTableDTO> getTablesInfo();
}
