package csbase.client.applications.flowapplication.graph;

/**
 * Define uma configurao de posicionamento e de dimensionamento dos ns de um
 * grafo.
 */
public interface GraphLayout {

  /**
   * Retorna uma nova configurao para a posio e dimenso dos ns de um grafo
   * a partir da configurao atual dos ns.
   * 
   * @param graph o grafo a ser reconfigurado.
   */
  public void doLayout(Graph graph);

  /**
   * Indica se a configurao pode ser aplicada a um grafo especfico.
   * 
   * @param graph o grafo.
   * @return verdadeiro se a configurao pode ser aplicado ou falso, caso
   *         contrrio.
   */
  public boolean canApplyLayout(Graph graph);

}
