/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.Application;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmSelectionPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.logic.algorithms.AlgorithmInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.gui.GBC;

public class AlgorithmListView {
    private SortedSet<AlgorithmInfo> algorithms;
    private JList algoList;
    private AlgorithmSelectionPanel selectionPanel;

    public AlgorithmListView(AlgorithmSelectionPanel selectionPanel, SortedSet<AlgorithmInfo> algorithms) {
        this.selectionPanel = selectionPanel;
        this.algorithms = algorithms;
        this.algoList = this.buildAlgorithmListComponent();
    }

    public List<DataInterface> getSelectedDataList() {
        Object[] selectedValues;
        Vector<DataInterface> selectedList = new Vector<DataInterface>();
        for (Object value : selectedValues = this.algoList.getSelectedValues()) {
            selectedList.add((DataInterface)value);
        }
        return selectedList;
    }

    public JPanel getPanel() {
        return this.buildAlgoListPanel();
    }

    private JPanel buildAlgoListPanel() {
        JPanel algoListPanel = new JPanel(new GridBagLayout());
        JLabel description = new JLabel(this.getApplication().getString("AlgorithmListView.description.algorithms.available"));
        this.algoList = this.buildAlgorithmListComponent();
        JScrollPane algoPane = new JScrollPane(this.algoList);
        algoListPanel.add((Component)description, new GBC(0, 0).none().west().insets(5, 5, 5, 5));
        algoListPanel.add((Component)algoPane, new GBC(0, 1).both().west().insets(5, 5, 5, 5));
        return algoListPanel;
    }

    private Application getApplication() {
        return this.selectionPanel.getApplication();
    }

    private JList buildAlgorithmListComponent() {
        if (this.algoList == null) {
            this.algoList = new JList();
            this.algoList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getSource() instanceof JList) {
                        JList algoList = (JList)e.getSource();
                        AlgorithmListView.this.selectionPanel.initAlgorithmSelection((AlgorithmListItem)algoList.getSelectedValue());
                        if (algoList.getSelectedIndex() != -1) {
                            algoList.ensureIndexIsVisible(algoList.getSelectedIndex());
                        }
                    }
                }
            });
        }
        this.algoList.setModel(new DefaultComboBoxModel<AlgorithmListItem>(this.getAlgorithmListItems()));
        this.algoList.setSelectionMode(2);
        this.algoList.setLayoutOrientation(0);
        this.algoList.setVisibleRowCount(15);
        return this.algoList;
    }

    private Vector<AlgorithmListItem> getAlgorithmListItems() {
        Vector<AlgorithmListItem> listItems = new Vector<AlgorithmListItem>();
        for (AlgorithmInfo algoInfo : this.algorithms) {
            listItems.add(new AlgorithmListItem(algoInfo));
        }
        return listItems;
    }

    public AlgorithmListItem getAlgorithmItem(AlgorithmInfo algoInfo) {
        int index = this.getAlgorithmIndex(algoInfo);
        return (AlgorithmListItem)this.algoList.getModel().getElementAt(index);
    }

    private int getAlgorithmIndex(AlgorithmInfo algoInfo) {
        int i = 0;
        for (AlgorithmInfo algorithm : this.algorithms) {
            if (algorithm.equals((Object)algoInfo)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getSelectedIndex() {
        return this.algoList.getSelectedIndex();
    }

    public int getSelectionCount() {
        return this.algoList.getSelectedValues().length;
    }

    public int getCount() {
        return this.algorithms.size();
    }

    public void selectAlgorithm(AlgorithmInfo algoInfo) {
        int algoIndex = this.getAlgorithmIndex(algoInfo);
        this.selectAlgorithmIndex(algoIndex);
    }

    public void selectAlgorithmIndex(int index) {
        this.algoList.setSelectedIndex(index);
    }
}

