/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph.actions;

import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.FlowTransferable;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddGraphPopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.actions.GraphAction;
import csbase.client.applications.flowapplication.messages.CheckClipboardFlavorMessage;
import csbase.client.applications.flowapplication.messages.PasteMessage;
import csbase.client.applications.flowapplication.messages.SelectElementsMessage;
import java.awt.event.ActionEvent;
import java.util.Collection;
import tecgraf.vix.TypeMessage;
import tecgraf.vix.TypeVO;
import tecgraf.vix.TypeVS;

public class PasteSelectedElementsAction
extends GraphAction {
    private Workspace workspace;

    public PasteSelectedElementsAction(Graph graph, Workspace workspace) {
        super(graph, PasteSelectedElementsAction.class.getName() + ".name", FlowApplicationUI.PASTE_NODE_ICON);
        this.workspace = workspace;
        boolean canPaste = CheckClipboardFlavorMessage.canPasteFromClipboard((TypeVS)this.getGraph(), FlowTransferable.DATA_FLAVOR);
        this.setEnabled(canPaste);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Graph graph = this.getGraph();
        PasteMessage pasteMessage = new PasteMessage();
        pasteMessage.sendVS((TypeVS)graph);
        if (pasteMessage.getTransferable() != null) {
            pasteMessage.sendVO((TypeVO)graph);
            Collection<GraphElement> elements = pasteMessage.getAffectedElements();
            if (elements != null) {
                this.workspace.sendVO((TypeMessage)new SelectElementsMessage(elements));
            }
        }
    }

    public static WorkspaceFilter createFilter(final Workspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("O par\u00e2metro workspace est\u00e1 nulo.");
        }
        return new AddGraphPopupActionFilter(workspace){

            @Override
            protected GraphAction createAction(Graph graph) {
                return new PasteSelectedElementsAction(graph, workspace);
            }
        };
    }
}

