/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph.utils;

import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.ParametersTransferable;
import csbase.client.applications.flowapplication.graph.utils.OperationStatus;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class CopyAndPasteOperation {
    private final GraphNode fromNode;
    private final GraphNode toNode;
    private final ParametersTransferable parameters;
    private boolean copyLinks;
    private final Map<Object, Object> memento;

    public CopyAndPasteOperation(GraphNode fromNode, GraphNode toNode, boolean copyLinks) {
        this(new ParametersTransferable(fromNode), fromNode, toNode, copyLinks);
    }

    public CopyAndPasteOperation(ParametersTransferable parameters, GraphNode toNode) {
        this(parameters, null, toNode, false);
    }

    protected CopyAndPasteOperation(ParametersTransferable parameters, GraphNode fromNode, GraphNode toNode, boolean copyLinks) {
        if (toNode == null) {
            throw new IllegalArgumentException("O par\u00e2metro toNode est\u00e1 nulo!");
        }
        if (fromNode == null) {
            this.copyLinks = false;
            if (parameters == null) {
                throw new IllegalArgumentException("Os par\u00e2metros fromNode e parameters est\u00e3o nulos!");
            }
        } else {
            this.copyLinks = copyLinks;
        }
        this.fromNode = fromNode;
        this.parameters = parameters;
        this.toNode = toNode;
        this.memento = this.getMemento();
    }

    public OperationStatus execute() {
        OperationStatus status = this.paste();
        boolean confirm = this.showConfirmationDialogIfNeeded(status);
        if (!confirm) {
            this.rollbackPaste();
        }
        status.setConfirmed(confirm);
        return status;
    }

    protected Map<Object, Object> getMemento() {
        AlgorithmConfiguratorView algorithmConfiguratorView = this.toNode.getAlgorithmConfiguratorView();
        AlgorithmConfigurator configurator = algorithmConfiguratorView.getConfigurator();
        return configurator.exportValues();
    }

    protected OperationStatus paste() {
        OperationStatus status = new OperationStatus();
        if (!this.toNode.isWellFormed()) {
            String errorMessage = MessageFormat.format(LNG.get((String)(CopyAndPasteOperation.class.getName() + ".error_wrong_labels")), this.toNode.getAlgorithmName());
            status.addError(errorMessage);
        }
        Set<String> parameterNames = this.parameters.getParameterNames();
        for (String parameterName : parameterNames) {
            if (this.parameterExists(parameterName)) {
                String parameterType = this.parameters.getParameterType(parameterName);
                if (this.hasSameParameterType(parameterName, parameterType)) {
                    String parameterLabel = this.parameters.getParameterLabel(parameterName);
                    if (!this.hasSameParameterLabel(parameterName, parameterLabel)) {
                        String newParameterLabel = "";
                        try {
                            newParameterLabel = this.toNode.getParameterLabel(parameterName);
                        }
                        catch (ParameterNotFoundException parameterNotFoundException) {
                            // empty catch block
                        }
                        String warningMessage = MessageFormat.format(LNG.get((String)(CopyAndPasteOperation.class.getName() + ".error_wrong_labels")), parameterName, parameterLabel, newParameterLabel);
                        status.addWarning(warningMessage);
                    }
                    String parameterValue = null;
                    try {
                        parameterValue = this.parameters.getParameterValue(parameterName);
                        this.toNode.setParameterValue(parameterName, parameterValue);
                    }
                    catch (ParseException e) {
                        String errorMessage = MessageFormat.format(LNG.get((String)(CopyAndPasteOperation.class.getName() + ".error_pasting_value")), parameterName, parameterValue);
                        status.addError(errorMessage);
                    }
                    catch (ParameterNotFoundException parameterNotFoundException) {}
                    continue;
                }
                String errorMessage = MessageFormat.format(LNG.get((String)(CopyAndPasteOperation.class.getName() + ".error_wrong_types")), parameterName);
                status.addError(errorMessage);
                continue;
            }
            String warningMessage = MessageFormat.format(LNG.get((String)(CopyAndPasteOperation.class.getName() + ".warning_no_parameter")), parameterName);
            status.addWarning(warningMessage);
        }
        if (this.copyLinks && !this.copyLinks()) {
            String errorMessage = LNG.get((String)(CopyAndPasteOperation.class.getName() + ".error_links"));
            status.addError(errorMessage);
        }
        return status;
    }

    protected boolean hasSameParameterLabel(String parameterName, String parameterLabel) {
        String nodeParameterLabel;
        try {
            nodeParameterLabel = this.toNode.getParameterLabel(parameterName);
        }
        catch (ParameterNotFoundException e) {
            return false;
        }
        return nodeParameterLabel.equals(parameterLabel);
    }

    protected boolean hasSameParameterType(String parameterName, String parameterType) {
        String nodeParameterType;
        try {
            nodeParameterType = this.toNode.getParameterType(parameterName);
        }
        catch (ParameterNotFoundException e) {
            return false;
        }
        return nodeParameterType.equals(parameterType);
    }

    protected boolean parameterExists(String parameterName) {
        return this.toNode.getParameterNames().contains(parameterName);
    }

    protected boolean showConfirmationDialogIfNeeded(OperationStatus status) {
        List<String> errors = status.getErrors();
        List<String> warnings = status.getWarnings();
        if (!warnings.isEmpty() || !errors.isEmpty()) {
            String title = LNG.get((String)(CopyAndPasteOperation.class.getName() + ".title"));
            StringBuilder content = new StringBuilder();
            content.append("<html>");
            content.append("<b>");
            content.append(LNG.get((String)(CopyAndPasteOperation.class.getName() + ".header")));
            content.append("</b>");
            if (!errors.isEmpty()) {
                content.append("<br><br>");
                content.append("<i>");
                content.append(LNG.get((String)(CopyAndPasteOperation.class.getName() + ".errors")));
                content.append("</i>");
                content.append("<ul>");
                for (String error : errors) {
                    content.append("<li>" + error + "</li>");
                }
                content.append("</ul>");
            }
            if (!warnings.isEmpty()) {
                if (errors.isEmpty()) {
                    content.append("<br><br>");
                }
                content.append("<i>");
                content.append(LNG.get((String)(CopyAndPasteOperation.class.getName() + ".warnings")));
                content.append("</i>");
                content.append("<ul>");
                for (String warning : warnings) {
                    content.append("<li>" + warning + "</li>");
                }
                content.append("</ul>");
            }
            content.append("</html>");
            int result = StandardDialogs.showYesNoDialog((Component)this.toNode.getGraph().getParentWindow(), (String)title, (Object)content);
            if (result == 1) {
                return false;
            }
        }
        return true;
    }

    protected void rollbackPaste() {
        AlgorithmConfigurator configurator = this.toNode.getAlgorithmConfiguratorView().getConfigurator();
        try {
            configurator.importValues(this.memento);
        }
        catch (ParseException e) {
            StandardErrorDialogs.showErrorDialog(this.toNode.getGraph().getParentWindow(), e);
        }
    }

    public boolean copyLinks() {
        boolean result = this.copyFromLinks();
        return result && this.copyToLinks();
    }

    protected boolean copyFromLinks() {
        if (this.fromNode != null) {
            boolean result = true;
            Collection<GraphLink> fromLinks = this.fromNode.getLinkFromCollection();
            for (GraphLink fromLink : fromLinks) {
                GraphNode endNode;
                if (!this.canCopyLink(fromLink, this.toNode, endNode = fromLink.getEndNode())) continue;
                result = result && this.copyLink(fromLink, this.toNode, endNode);
            }
            return result;
        }
        return false;
    }

    protected boolean copyToLinks() {
        if (this.fromNode != null) {
            boolean result = true;
            Collection<GraphLink> toLinks = this.fromNode.getLinkToCollection();
            for (GraphLink toLink : toLinks) {
                GraphNode startNode;
                if (!this.canCopyLink(toLink, startNode = toLink.getStartNode(), this.toNode)) continue;
                result = result && this.copyLink(toLink, startNode, this.toNode);
            }
            return result;
        }
        return false;
    }

    protected boolean copyLink(GraphLink link, GraphNode startNode, GraphNode endNode) {
        try {
            String outputParamName = link.getOutputFileDescriptor().getParameterName();
            String inputParamName = link.getInputFileDescriptor().getParameterName();
            GraphFileDescriptor inputFileDescriptor = endNode.getInputFileDescriptor(inputParamName);
            GraphFileDescriptor outputFileDescriptor = startNode.getOutputFileDescriptor(outputParamName);
            if (inputFileDescriptor != null && outputFileDescriptor != null) {
                List<Point2D> pointList = link.getIntermediatePointList();
                link.deattach();
                Graph graph = startNode.getGraph();
                graph.createGraphLink(inputFileDescriptor, outputFileDescriptor, pointList);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean canCopyLink(GraphLink link, GraphNode startNode, GraphNode endNode) {
        if (startNode == null || endNode == null || link == null) {
            return false;
        }
        String outputParamName = link.getOutputFileDescriptor().getParameterName();
        String inputParamName = link.getInputFileDescriptor().getParameterName();
        GraphFileDescriptor inputFileDescriptor = endNode.getInputFileDescriptor(inputParamName);
        GraphFileDescriptor outputFileDescriptor = startNode.getOutputFileDescriptor(outputParamName);
        return inputFileDescriptor != null && outputFileDescriptor != null;
    }
}

