/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.logic.ProjectBasicInfo;
import csbase.logic.SharedObject;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SharedObjectServiceInterface;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.LinkedList;

public class RecentProjectsManager {
    private static final int MAX_PROJECTS = 11;
    private static final String RECENT_PROJECTS = "recent_projects";
    private static final String RECENT_PROJECTS_CATEGORY = "RecentProjects";

    public Object[] getRecentProjectsIds() throws RemoteException {
        SharedObject sharedObject = this.readSharedObject();
        if (sharedObject != null) {
            Collection<ProjectBasicInfo> projectsInfos = this.getProjectsInfosFromSharedObject(sharedObject);
            return projectsInfos.toArray(new String[projectsInfos.size()]);
        }
        return new String[0];
    }

    private SharedObject readSharedObject() throws RemoteException {
        SharedObjectServiceInterface sharedObjectService = ClientRemoteLocator.sharedObjectService;
        try {
            SharedObject sharedObject = sharedObjectService.getSharedObject(RECENT_PROJECTS_CATEGORY, User.getLoggedUser().getId(), RECENT_PROJECTS);
            return sharedObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Collection<ProjectBasicInfo> getProjectsInfosFromSharedObject(SharedObject so) {
        LinkedList<ProjectBasicInfo> projectsHistoryInfos = new LinkedList<ProjectBasicInfo>();
        if (so == null || so.getContents() == null) {
            return projectsHistoryInfos;
        }
        projectsHistoryInfos.addAll((Collection)so.getContents());
        return projectsHistoryInfos;
    }

    public Collection<ProjectBasicInfo> getProjectsInfosFromHistory() throws RemoteException {
        SharedObject so = this.readSharedObject();
        return this.getProjectsInfosFromSharedObject(so);
    }

    public void saveProjectInfo(ProjectBasicInfo projectBasicInfo) throws RemoteException {
        if (projectBasicInfo == null) {
            return;
        }
        SharedObject sharedObj = this.readSharedObject();
        LinkedList projectsHistoryInfos = (LinkedList)this.getProjectsInfosFromSharedObject(sharedObj);
        if (projectsHistoryInfos.contains(projectBasicInfo)) {
            projectsHistoryInfos.remove(projectBasicInfo);
        }
        if (projectsHistoryInfos.size() == 11) {
            projectsHistoryInfos.removeLast();
        }
        projectsHistoryInfos.addFirst(projectBasicInfo);
        if (sharedObj == null) {
            sharedObj = this.createSharedObject(projectsHistoryInfos);
        } else {
            sharedObj.setContents((Object)projectsHistoryInfos);
        }
        SharedObjectServiceInterface sharedObjectService = ClientRemoteLocator.sharedObjectService;
        sharedObjectService.saveSharedObject(sharedObj);
    }

    private SharedObject createSharedObject(Object contents) {
        SharedObject obj = new SharedObject(RECENT_PROJECTS_CATEGORY, User.getLoggedUser().getId(), RECENT_PROJECTS, true, contents);
        return obj;
    }
}

