/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import csbase.client.Client;
import csbase.client.applications.ApplicationImages;
import csbase.client.util.StandardErrorDialogs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import tecgraf.javautils.core.lng.LNG;

public class ClientUtilities {
    public static String addSystemNameToTitle(String title) {
        return title + " - " + LNG.get((String)"SERVER");
    }

    public static String addSystemAndServerNameToTitle(String title) {
        return title + " - " + LNG.get((String)"SERVER") + " (" + Client.getInstance().getServerName() + ")";
    }

    public static void adjustEqualSizes(JComponent ... comps) {
        int i;
        Dimension dim = new Dimension(0, 0);
        for (i = 0; i < comps.length; ++i) {
            Dimension pref = comps[i].getPreferredSize();
            double h = Math.max(dim.getHeight(), pref.getHeight());
            double w = Math.max(dim.getWidth(), pref.getWidth());
            dim.setSize(w, h);
        }
        for (i = 0; i < comps.length; ++i) {
            comps[i].setPreferredSize(dim);
        }
    }

    public static JButton createImageButton(ImageIcon icon) {
        JButton button = new JButton();
        button.setIcon(icon);
        ClientUtilities.trimImageButton(button);
        return button;
    }

    public static void trimImageButton(JButton button) {
        Icon icon = button.getIcon();
        Dimension size = new Dimension(icon.getIconWidth() + 2, icon.getIconHeight() + 2);
        button.setPreferredSize(size);
        button.setMaximumSize(size);
        button.setMinimumSize(size);
    }

    public static JPanel createBasicGridPanel(JComponent[][] rows) {
        JPanel basicGridPanel = new JPanel();
        ClientUtilities.populateBasicGridPanel(basicGridPanel, rows);
        return basicGridPanel;
    }

    public static void populateBasicGridPanel(JPanel basicGridPanel, JComponent[][] rows) {
        basicGridPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.insets = new Insets(2, 2, 2, 5);
        constraints.anchor = 18;
        for (int rowNumber = 0; rowNumber < rows.length; ++rowNumber) {
            JComponent[] row = rows[rowNumber];
            if (row == null || row.length == 0) continue;
            JComponent firstCell = row[0];
            JComponent middleCell = row.length > 1 ? row[1] : null;
            JComponent lastCell = row.length > 2 ? row[2] : null;
            constraints.gridy = rowNumber;
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            if (firstCell != null) {
                constraints.gridx = 0;
                basicGridPanel.add((Component)firstCell, constraints);
            }
            if (lastCell != null) {
                constraints.gridx = 2;
                basicGridPanel.add((Component)lastCell, constraints);
            }
            if (middleCell == null) continue;
            constraints.weightx = 100.0;
            constraints.weighty = 100.0;
            constraints.fill = 2;
            constraints.gridx = 1;
            constraints.gridwidth = lastCell == null ? 2 : 1;
            basicGridPanel.add((Component)middleCell, constraints);
        }
    }

    public static void showErrorByButton(Window window, String msg, JButton button) {
        button.setIcon(ApplicationImages.ICON_STOP_16);
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(window, msg, ClientUtilities.addSystemNameToTitle(LNG.get((String)"UTILITIES_INPUT_ERROR")), 0);
        button.requestFocus();
        button.setIcon(null);
    }

    public static void showErrorByComponent(Window window, String msg, JLabel label, JComponent component) {
        if (label != null) {
            label.setIcon(ApplicationImages.ICON_STOP_16);
        }
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(window, msg, ClientUtilities.addSystemNameToTitle(LNG.get((String)"UTILITIES_INPUT_ERROR")), 0);
        if (component != null) {
            component.requestFocus();
        }
        if (label != null) {
            label.setIcon(null);
        }
    }

    public static void showErrorByComponent(Window window, Exception exception, JLabel label, JComponent component) {
        if (label != null) {
            label.setIcon(ApplicationImages.ICON_STOP_16);
        }
        Toolkit.getDefaultToolkit().beep();
        StandardErrorDialogs.showErrorDialog(window, exception);
        if (component != null) {
            component.requestFocus();
        }
        if (label != null) {
            label.setIcon(null);
        }
    }

    public static void addComponent2Panel(JPanel panel, JComponent component, GridBagConstraints c, int gx, int gy, int w, int h, int wx, int wy) {
        c.gridx = gx;
        c.gridy = gy;
        c.gridwidth = w;
        c.gridheight = h;
        c.weightx = wx;
        c.weighty = wy;
        panel.add((Component)component, c);
    }

    public static void showErrorByTextField(Window window, String msg, JLabel label, JTextField field) {
        if (label != null) {
            label.setIcon(ApplicationImages.ICON_STOP_16);
        }
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(window, msg, ClientUtilities.addSystemNameToTitle(LNG.get((String)"UTILITIES_INPUT_ERROR")), 0);
        if (field != null) {
            field.requestFocus();
            field.setSelectionStart(0);
            field.setSelectionEnd(field.getText().length());
        }
        if (label != null) {
            label.setIcon(null);
        }
    }

    public static void showErrorByTable(Window window, String msg, JLabel label, JTable table, int row, int col) {
        if (label != null) {
            label.setIcon(ApplicationImages.ICON_STOP_16);
        }
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(window, msg, ClientUtilities.addSystemNameToTitle(LNG.get((String)"UTILITIES_INPUT_ERROR")), 0);
        if (table != null) {
            table.requestFocus();
            table.clearSelection();
            table.changeSelection(row, col, true, true);
        }
        if (label != null) {
            label.setIcon(null);
        }
    }

    public static boolean validatePathChars(String path) {
        return !path.equals("") && path.matches("^[\\w\\.\\-/]+$");
    }

    public static boolean loadStringMap(Locale locale) {
        String[] propertiesFiles = new String[]{"csbase.client.resources.properties.language.metal", "csbase.client.resources.properties.language.basic", "csbase.client.resources.properties.language.awt"};
        for (int i = 0; i < propertiesFiles.length; ++i) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle(propertiesFiles[i], locale);
                Enumeration<String> e = rb.getKeys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    UIManager.put(key, rb.getString(key));
                }
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static void setLanguage(Locale locale) {
        String idiomFile = "csbase.client.resources.properties.language.idiom";
        LNG.load((String)idiomFile, (Locale)locale);
    }

    public static boolean isValidFileName(String name) {
        return !name.equals("") && name.matches("^[\\w\\.\\-]+$");
    }

    public static void centerWindow(Window window, Window refWindow) {
        while (refWindow != null && !refWindow.isVisible()) {
            refWindow = refWindow.getOwner();
        }
        Dimension size = null;
        Point local = null;
        if (refWindow != null) {
            size = refWindow.getSize();
            local = refWindow.getLocationOnScreen();
        } else {
            size = Toolkit.getDefaultToolkit().getScreenSize();
            local = new Point(0, 0);
        }
        int x = size.width / 2 + local.x;
        int y = size.height / 2 + local.y;
        Dimension wsize = window.getSize();
        window.setLocation(x -= wsize.width / 2, y -= wsize.height / 2);
    }

    public static final Comparator getStringComparatorIgnoreCase() {
        return new StringComparatorIgnoreCase();
    }

    public static void applyUndoRedoActions(JTextComponent textcomp) {
        final UndoManager undoManager = new UndoManager();
        Document doc = textcomp.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undoManager.addEdit(evt.getEdit());
            }
        });
        textcomp.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        textcomp.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        textcomp.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    private static class StringComparatorIgnoreCase
    implements Comparator<String>,
    Serializable {
        private StringComparatorIgnoreCase() {
        }

        @Override
        public int compare(String s1, String s2) {
            String n1 = StringComparatorIgnoreCase.removeSpecialChar(s1);
            String n2 = StringComparatorIgnoreCase.removeSpecialChar(s2);
            return n1.compareToIgnoreCase(n2);
        }

        private static String removeSpecialChar(String str) {
            if (str != null && str.trim().length() > 0) {
                String[] replaces = new String[]{"a", "e", "i", "o", "u", "c"};
                Pattern[] patternsArray = new Pattern[replaces.length];
                patternsArray[0] = Pattern.compile("[\u00e2\u00e3\u00e1\u00e0\u00e4]", 2);
                patternsArray[1] = Pattern.compile("[\u00e9\u00e8\u00ea\u00eb]", 2);
                patternsArray[2] = Pattern.compile("[\u00ed\u00ec\u00ee\u00ef]", 2);
                patternsArray[3] = Pattern.compile("[\u00f3\u00f2\u00f4\u00f5\u00f6]", 2);
                patternsArray[4] = Pattern.compile("[\u00fa\u00f9\u00fb\u00fc]", 2);
                patternsArray[5] = Pattern.compile("[\u00e7]", 2);
                for (int i = 0; i < patternsArray.length; ++i) {
                    Matcher matcher = patternsArray[i].matcher(str);
                    str = matcher.replaceAll(replaces[i]);
                }
            }
            return str;
        }
    }
}

