package csbase.client.applicationmanager;

import java.io.File;

import tecgraf.javautils.core.lng.LNG;

/**
 * Enumerao de locais possveis para a cache de aplicaes.
 * 
 * @author Tecgraf
 */
public enum CSDKCacheLocation {

  /**
   * Diretrio do usurio.
   */
  USER_HOME,
  /**
   * Diretrio temporrio.
   */
  JAVA_IO_TMPDIR;

  /**
   * Obtm o caminho para o local.
   * 
   * @return o caminho.
   */
  public File getPath() {
    switch (this) {
      case USER_HOME:
        String homeDir = System.getProperty("user.home");
        return new File(homeDir);
      case JAVA_IO_TMPDIR:
        String tmpDir = System.getProperty("java.io.tmpdir");
        return new File(tmpDir);
      default:
        return null;
    }
  }

  /**
   * Obtm a descrio do local.
   * 
   * @return a descrio.
   */
  public String getDescription() {
    return LNG.get(getClass().getSimpleName() + "." + this.name()
      + ".description");
  }

}
