package csbase.client.applications.algorithmsmanager.dialogs;

import static csbase.client.remote.srvproxies.AlgorithmManagementProxy
  .AlgorithmOperation.ADMIN_ALGORITHM;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmOutline;
import csdk.v1_0.helper.application.ApplicationImages;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

/**
 * Painel de cabealho com informaes imutveis do algoritmo.
 */
public class AlgorithmStaticInfoPanel extends
  AbstractSimpleApplicationPanel<AlgorithmsManager> {

  /**
   * Campo texto com o nome do algoritmo
   */
  private JTextField nameText;

  /**
   * Campo texto com o id do algoritmo
   */
  private JTextField idText;

  /**
   * Construtor.
   *
   * @param application a aplicao.
   */
  public AlgorithmStaticInfoPanel(AlgorithmsManager application) {
    super(application);
    buildPanel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void buildPanel() {
    nameText = new JTextField(30);
    nameText.setEditable(false);

    JButton renameButton = new JButton(ApplicationImages.ICON_EDIT_16);
    final String renameTooltip =
      getString("AlgorithmStaticInfoPanel.rename.tooltip");
    renameButton.setToolTipText(renameTooltip);
    renameButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        openRenameDialog();
      }
    });

    idText = new JTextField(30);
    idText.setEditable(false);

    setLayout(new GridBagLayout());
    final String idStr = getString("AlgorithmStaticInfoPanel.label.id");
    final String nameStr = getString("AlgorithmStaticInfoPanel.label.name");

    JLabel idLabel = new JLabel(idStr);
    JLabel nameLabel = new JLabel(nameStr);

    GUIUtils.mountBasicGridPanel(this,
      new JComponent[][] { { nameLabel, nameText, renameButton }, { idLabel,
        idText, null }, });
  }

  /**
   * Abre a janela de renomeao do algoritmo.
   */
  private void openRenameDialog() {
    AlgorithmsManager application = getApplication();
    String nameLabel = getString("AlgorithmStaticInfoPanel.rename.label");
    String warningMsg = getString("AlgorithmStaticInfoPanel.rename.warning");
    String title = getString("AlgorithmStaticInfoPanel.rename.title");

    String currentName = nameText.getText();
    String newName = (String) JOptionPane
      .showInputDialog(nameText, warningMsg + "\n\n" + nameLabel, title,
        JOptionPane.WARNING_MESSAGE, null, null, currentName);
    if (newName != null) {
      newName = newName.trim();
      if (!newName.isEmpty() && !newName.equals(currentName)) {
        if (isNameAvailable(newName)) {
          ApplicationFrame frame = application.getApplicationFrame();
          String id = idText.getText();
          AlgorithmManagementProxy.renameAlgorithm(id, newName.trim(), frame);
        }
        else {
          String error = getString("AlgorithmStaticInfoPanel.rename.error",
            new Object[] { newName });
          StandardDialogs.showErrorDialog(nameText, title, error);
        }
      }
    }
  }

  /**
   * Verifica se o nome est disponvel (se no est sendo usado por outro
   * algoritmo).
   *
   * @param name o nome a ser verificado.
   * @return verdadeiro se o nome puder ser usado ou falso, caso contrrio.
   */
  private boolean isNameAvailable(String name) {
    ApplicationFrame frame = getApplication().getApplicationFrame();
    AlgorithmOutline[] outlines =
      AlgorithmManagementProxy.getAllAlgorithmOutlines(frame, ADMIN_ALGORITHM);
    for (AlgorithmOutline outline : outlines) {
      if (outline.getName().trim().equals(name)) {
        return false;
      }
    }
    return true;
  }

  /**
   * Define o algoritmo a ser mostrado no painel.
   *
   * @param algorithm o algoritmo selecionado.
   */
  public void setSelectedAlgorithm(AlgorithmListItem algorithm) {
    String name = null;
    String id = null;
    if (algorithm != null) {
      name = algorithm.getName();
      id = algorithm.getId();
    }
    nameText.setText(name);
    idText.setText(id);
  }
}
