package csbase.client.applications.filetransferclient.actions;

import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.logic.filetransferservice.FileTransferRequestStatus;

/**
 * Ao de limpeza de requisies terminadas do prprio usurio
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ClearEndedAction extends FileTransferClientAction {

  /**
   * Indica se uma requisio j foi terminada.
   * 
   * @param request requisio
   * @return indicativo
   */
  private boolean isEndedRequest(final FileTransferRequest request) {
    final FileTransferRequestStatus status = request.getStatus();
    if (status == FileTransferRequestStatus.ERROR) {
      return true;
    }
    if (status == FileTransferRequestStatus.FINISHED) {
      return true;
    }
    if (status == FileTransferRequestStatus.INTERRUPTED) {
      return true;
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    final FileTransferClient application = getApplication();
    final FileTransferClientQueuePanel queuePanel = application.getQueuePanel();
    final List<FileTransferRequest> reqs = queuePanel.getAllRequests();
    final User loggedUser = User.getLoggedUser();
    final Object loggedId = loggedUser.getId();

    final List<String> ids = new ArrayList<String>();
    for (FileTransferRequest req : reqs) {
      final FileTransferConnection connection = req.getConnection();
      final Object userId = connection.getUserId();
      if (userId.equals(loggedId) && isEndedRequest(req)) {
        ids.add(req.getId());
      }
    }

    final FileTransferProxy proxy = application.getServiceProxy();
    proxy.removeRequests(ids);
    queuePanel.refresh();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public ClearEndedAction(final FileTransferClient application) {
    super(application);
  }
}
