package csbase.client.applications.sgamonitor.columns.util;

/**
 * Classe auxiliar que encapsula o nmero de jobs e o nmero de processadores de
 * um SGA.
 * 
 * @author Tecgraf
 */
public class JobProcessorPair implements Comparable<JobProcessorPair> {

  /**
   * Nmero de jobs.
   */
  private int jobs;

  /**
   * Nmero de processadores.
   */
  private int processors;

  /**
   * Construtor padro.
   * 
   * @param jobs - nmero de jobs.
   * @param processors - nmero de processadores.
   */
  public JobProcessorPair(int jobs, int processors) {
    super();
    this.jobs = jobs;
    this.processors = processors;
  }

  /**
   * Nmero de jobs.
   * 
   * @return nmero de jobs.
   */
  public int getJobs() {
    return jobs;
  }

  /**
   * Nmero de jobs.
   * 
   * @param jobs - nmero de jobs.
   */
  public void setJobs(int jobs) {
    this.jobs = jobs;
  }

  /**
   * Nmero de processadores.
   * 
   * @return nmero de processadores.
   */
  public int getProcessors() {
    return processors;
  }

  /**
   * Nmero de processadores.
   * 
   * @param processors - nmero de processadores.
   */
  public void setProcessors(int processors) {
    this.processors = processors;
  }

  /**
   * Obtm a razo entre o nmero de jobs e o nmero de processadores.
   * 
   * @return razo entre o nmero de jobs e o nmero de processadores.
   */
  public double getFactor() {
    return (processors != 0) ? jobs / (processors + 0.0) : 0.0;
  }

  /**
   * Obtm a razo como inteiro entre 0 e 100.
   * 
   * @return razo como inteiro entre 0 e 100.
   */
  public int getFactorAsInt() {
    return (int) Math.round(getFactor() * 100);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return getJobs() + "/" + getProcessors();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int compareTo(JobProcessorPair o) {
    double myFactor = this.getFactor();
    double otherFactor = o.getFactor();

    int result = 0;

    if (myFactor < otherFactor) {
      result = -1;
    }
    else if (myFactor > otherFactor) {
      result = 1;
    }

    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + jobs;
    result = prime * result + processors;
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    JobProcessorPair other = (JobProcessorPair) obj;
    if (jobs != other.jobs) {
      return false;
    }
    if (processors != other.processors) {
      return false;
    }
    return true;
  }

}
