/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.panels.remotepanel;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.logic.filetransferservice.FileTransferElement;
import java.awt.Color;
import java.awt.Component;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import tecgraf.javautils.core.lng.FormatUtils;

class RemoteTableRenderer
implements TableCellRenderer {
    public static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component renderer = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        JLabel label = (JLabel)renderer;
        label.setOpaque(true);
        label.setIcon(null);
        label.setHorizontalAlignment(2);
        label.setForeground(Color.black);
        if (column == 0) {
            FileTransferElement file = (FileTransferElement)value;
            label.setHorizontalAlignment(0);
            ImageIcon icon = null;
            icon = file.isDirectory() ? FileTransferClientUI.IMG_TYPE_DIRECTORY : FileTransferClientUI.IMG_TYPE_FILE;
            if (file.isLink()) {
                icon = FileTransferClientUI.IMG_TYPE_LINK;
            }
            label.setIcon(icon);
            label.setText(null);
        } else if (column == 1) {
            String name = (String)value;
            label.setHorizontalAlignment(2);
            label.setText(name);
        } else if (column == 2) {
            long size = (Long)value;
            if (size < 0L) {
                label.setText(null);
            } else {
                label.setHorizontalAlignment(4);
                ApplicationManager mgr = ApplicationManager.getInstance();
                label.setText(FormatUtils.formatSize((long)size, (int)2, (Locale)mgr.getLocale()));
            }
        }
        return label;
    }
}

