/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication;

import csbase.client.ClientKeyStrokeUtil;
import csbase.client.algorithms.AlgorithmFavoriteAddAction;
import csbase.client.algorithms.AlgorithmFavoriteRemoveAction;
import csbase.client.algorithms.AlgorithmHelpAction;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationEditPrefAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.flowapplication.AlgorithmTreeNode;
import csbase.client.applications.flowapplication.AlgorithmVersionTransferable;
import csbase.client.applications.flowapplication.AlgorithmVersionTreeNode;
import csbase.client.applications.flowapplication.AllCategoryTreeNode;
import csbase.client.applications.flowapplication.FlowApplicationPref;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.actions.AlgorithmComponentFocusAction;
import csbase.client.applications.flowapplication.actions.AskForParameterValuesAction;
import csbase.client.applications.flowapplication.actions.CloseAction;
import csbase.client.applications.flowapplication.actions.CopyElementsAction;
import csbase.client.applications.flowapplication.actions.ExecuteGraphAction;
import csbase.client.applications.flowapplication.actions.ExportMultipleConfigurationAction;
import csbase.client.applications.flowapplication.actions.ListOutdatedFlowsAction;
import csbase.client.applications.flowapplication.actions.LoadAction;
import csbase.client.applications.flowapplication.actions.MultipleExecuteGraphAction;
import csbase.client.applications.flowapplication.actions.NewAction;
import csbase.client.applications.flowapplication.actions.OrthogonalLinkLayoutAction;
import csbase.client.applications.flowapplication.actions.PasteElementsAction;
import csbase.client.applications.flowapplication.actions.RemoveElementsAction;
import csbase.client.applications.flowapplication.actions.SaveAction;
import csbase.client.applications.flowapplication.actions.SaveAsAction;
import csbase.client.applications.flowapplication.actions.ShowParameterValuesAction;
import csbase.client.applications.flowapplication.actions.SingleColumnGraphLayoutAction;
import csbase.client.applications.flowapplication.actions.UniformSizeLayoutAction;
import csbase.client.applications.flowapplication.actions.UpdateAlgorithmTreeAction;
import csbase.client.applications.flowapplication.actions.UpdateAllVersionsAction;
import csbase.client.applications.flowapplication.commandviewer.CommandPropertiesFilter;
import csbase.client.applications.flowapplication.commandviewer.CommandViewerPanel;
import csbase.client.applications.flowapplication.filters.AskForParameterValuesActionFilter;
import csbase.client.applications.flowapplication.filters.CopyAndPasteFilter;
import csbase.client.applications.flowapplication.filters.HighlightElementFilter;
import csbase.client.applications.flowapplication.filters.HintElementFilter;
import csbase.client.applications.flowapplication.filters.PopupFilter;
import csbase.client.applications.flowapplication.filters.ResizeNodeFilter;
import csbase.client.applications.flowapplication.filters.SelectElementFilter;
import csbase.client.applications.flowapplication.filters.UpdateStatusBarFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.FileTypeColorManager;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphListener;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.actions.BreakLinkAction;
import csbase.client.applications.flowapplication.graph.actions.BypassAction;
import csbase.client.applications.flowapplication.graph.actions.CopyParameterValuesAction;
import csbase.client.applications.flowapplication.graph.actions.CopySelectedElementsAction;
import csbase.client.applications.flowapplication.graph.actions.PasteParameterValuesAction;
import csbase.client.applications.flowapplication.graph.actions.PasteSelectedElementsAction;
import csbase.client.applications.flowapplication.graph.actions.RemoveSelectedElementsAction;
import csbase.client.applications.flowapplication.graph.actions.ShowAlgorithmHelpAction;
import csbase.client.applications.flowapplication.graph.actions.UpdateVersionAction;
import csbase.client.applications.flowapplication.messages.PickGraphMessage;
import csbase.client.applications.flowapplication.messages.RemoveElementsMessage;
import csbase.client.applications.flowapplication.messages.ResetMessage;
import csbase.client.applications.flowapplication.messages.ShowParameterValuesMessage;
import csbase.client.applications.flowapplication.util.FlowApplicationRemoteTask;
import csbase.client.applications.flowapplication.zoom.ZoomControl;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopPref;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.types.PVBoolean;
import csbase.client.preferences.types.PVList;
import csbase.client.preferences.util.PreferenceListener;
import csbase.client.project.ProjectTreePath;
import csbase.client.remote.AlgorithmManagementListener;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.gui.AlgorithmFilterParamPanel;
import csbase.client.util.gui.AlgorithmFilterParamPanelListener;
import csbase.client.util.gui.AlgorithmInfoFilterOperator;
import csbase.client.util.sga.CommandExecutionDialog;
import csbase.client.util.sga.CommandRequestedListener;
import csbase.client.util.sga.MultipleFlowCommandExecutionDialog;
import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.exception.project.FileLockedException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandInfo;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import csbase.logic.algorithms.commands.CommandPersistenceNotification;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowAlgorithmParser;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.MenuButton;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.StatusBar;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.tree.Filter;
import tecgraf.javautils.gui.tree.Node;
import tecgraf.javautils.gui.tree.Tree;
import tecgraf.vix.TypeMessage;

public final class FlowApplication
extends ApplicationProject {
    static final String FAVORITE_CATEGORY_ID = "-1";
    public static final String CONFIGURATOR_MESSAGE = "CONFIGURATOR_MESSAGE";
    private static final double VERTICAL_SPLITTER_LOCATION = 0.75;
    private Tree algorithmsTree;
    private AlgorithmFilterParamPanel algorithmFilterPanel;
    private JPanel algorithmsPanel;
    private final Workspace workspace;
    private JScrollPane workspaceScrollPane;
    private final CommandViewerPanel commandViewerPanel;
    private ZoomControl zoomControl;
    private StatusBar statusBar;
    private JSplitPane horizontalSplitPane;
    private final List<CommandRequestedListener> listeners;
    private final Set<String> commandIds;
    private final IMessageListener commandPersistenceListener;
    private List<WorkspaceFilter> popupFilters;
    private PopupFilter basicPopupFilter;
    private ResizeNodeFilter resizeNodeFilter;
    private static Clipboard clipboard = new Clipboard(FlowApplication.class.getName());
    private CopyAndPasteFilter copyAndPasteFilter;
    private AskForParameterValuesActionFilter askForParameterValuesFilter;
    private HighlightElementFilter hightLightFilter;
    private HintElementFilter hintFilter;
    private SelectElementFilter selectElementFilter;
    private UpdateStatusBarFilter updateStatusBarFilter;
    private LoadAction loadAction;
    private ExecuteGraphAction executeAction;
    private ExportMultipleConfigurationAction exportMultipleConfigurationAction;
    private MultipleExecuteGraphAction multipleExecuteAction;
    private NewAction newAction;
    private RemoveElementsAction removeAction;
    private CloseAction closeAction;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private UpdateAllVersionsAction updateVersionsAction;
    private UpdateAlgorithmTreeAction updateAlgorithmTreeAction;
    private ListOutdatedFlowsAction listOutdatedFlowsAction;
    private ShowParameterValuesAction showPropertiesAction;
    private CopyElementsAction copyAction;
    private PasteElementsAction pasteAction;
    private AlgorithmHelpAction helpAction;
    private AlgorithmFavoriteAddAction addFavoriteAction;
    private AlgorithmFavoriteRemoveAction removeFavoriteAction;
    private ProjectTreePath currentFilePath;
    private boolean wasChanged;
    private JTextField descriptionTextField;
    private MenuButton refreshMenuButton;
    private JMenuItem algTreeRefreshDetail;
    private List<Category> modifiedCategories;
    private List<AlgorithmInfo> modifiedAlgorithms;
    private boolean algorithmRepositoryReloaded = false;
    private KeyboardFocusManager keyFocusManager;
    private FlowApplicationKeyDispatcher keyDispatcher;
    private PreferenceCategory preferences;
    private boolean saveBeforeExecute = false;

    public FlowApplication(String id) throws ApplicationException {
        super(id);
        PreferenceCategory globalPreferences = this.getPreferences();
        this.preferences = globalPreferences.copy();
        boolean showVersionInWorkspace = this.preferences.getPreferenceAsBoolean(FlowApplicationPref.SHOW_VERSION_IN_WORKSPACE);
        boolean showVersionInTree = this.preferences.getPreferenceAsBoolean(FlowApplicationPref.SHOW_VERSION_IN_TREE);
        boolean autoCreateLinks = this.preferences.getPreferenceAsBoolean(FlowApplicationPref.AUTO_CREATE_LINKS);
        this.commandIds = new HashSet<String>();
        this.listeners = new LinkedList<CommandRequestedListener>();
        this.addPreferenceListeners();
        this.initAlgorithmsAndCategoriesUpdateFields();
        this.algorithmsPanel = this.createAlgorithmTreePanel(showVersionInTree);
        this.keyFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyDispatcher = new FlowApplicationKeyDispatcher();
        this.keyFocusManager.addKeyEventDispatcher(this.keyDispatcher);
        this.commandViewerPanel = new CommandViewerPanel(this.getApplicationFrame(), this.getApplicationProject().getId(), this.createCommandPropertiesFilter(), CommandViewerPanel.ToolBarLocation.LEFT){

            @Override
            protected boolean exportCommand(final CommandInfo command) {
                FlowApplicationRemoteTask<AlgorithmConfigurator> task = new FlowApplicationRemoteTask<AlgorithmConfigurator>(){

                    public void performTask() throws Exception {
                        AlgorithmConfigurator configurator = command.getConfigurator();
                        this.setResult(configurator);
                    }
                };
                String msg = FlowApplication.this.getString("loadingConfigurator");
                if (!task.execute(FlowApplication.this.getApplicationFrame(), msg, msg)) {
                    return false;
                }
                AlgorithmConfigurator configurator = (AlgorithmConfigurator)task.getResult();
                if (configurator.getConfiguratorType() != AlgorithmConfigurator.ConfiguratorType.FLOW) {
                    return false;
                }
                if (!FlowApplication.this.createNewGraph()) {
                    return false;
                }
                return FlowApplication.this.editConfigurator((FlowAlgorithmConfigurator)configurator, command.getDescription());
            }
        };
        this.workspace = new Workspace(this.getApplicationFrame(), true, false);
        this.workspace.setAutoCreateLinks(autoCreateLinks);
        this.workspace.setVersionInfoVisible(showVersionInWorkspace);
        this.workspace.getGraph().setVersionInfoVisible(showVersionInWorkspace);
        this.workspaceScrollPane = new JScrollPane(this.workspace, 22, 32);
        this.workspace.getGraph().addGraphListener(new ChangedListener());
        this.workspace.setTransferHandler(this.algorithmsTree.getTransferHandler());
        this.createFilters();
        ListIterator<WorkspaceFilter> popupFilterIterator = this.popupFilters.listIterator(this.popupFilters.size());
        while (popupFilterIterator.hasPrevious()) {
            WorkspaceFilter filter = popupFilterIterator.previous();
            filter.attach();
        }
        this.selectElementFilter.attach();
        this.resizeNodeFilter.attach();
        this.hightLightFilter.attach();
        this.hintFilter.attach();
        this.updateStatusBarFilter.attach();
        this.basicPopupFilter.attach();
        this.askForParameterValuesFilter.attach();
        this.copyAndPasteFilter.attach();
        this.createGui();
        this.addAlgorithmProxyListener();
        this.createNewGraph();
        try {
            List<String> fileTypes = this.getStringListSpecificProperty("file.type.name");
            List<String> rgbs = this.getStringListSpecificProperty("file.type.rgb");
            FileTypeColorManager.createInstance(fileTypes, rgbs);
        }
        catch (ParseException e) {
            throw new ApplicationException(e.getLocalizedMessage(), e);
        }
        this.commandPersistenceListener = new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                block5: for (Message message : messages) {
                    CommandPersistenceNotification notification = (CommandPersistenceNotification)message.getBody();
                    switch (notification.getType()) {
                        case REMOVED: {
                            FlowApplication.this.commandIds.remove(notification.getCommandId());
                            continue block5;
                        }
                        case SAVED: {
                            continue block5;
                        }
                        case UPDATED: {
                            continue block5;
                        }
                        default: {
                            String errorMessage = String.format("Notifica\u00e7\u00e3o de tipo desconhecido.\nProjeto: %s.\nComando: %s.\nTipo de notifica\u00e7\u00e3o: %s.\n", notification.getProjectId(), notification.getCommandId(), notification.getType());
                            throw new IllegalArgumentException(errorMessage);
                        }
                    }
                }
            }
        };
    }

    private void addPreferenceListeners() {
        PVBoolean versionInWorkspacePref = this.preferences.getPVBoolean(FlowApplicationPref.SHOW_VERSION_IN_WORKSPACE);
        versionInWorkspacePref.addPreferenceListener(new PreferenceListener<Boolean>(){

            @Override
            public void valueChanged(Boolean oldValue, Boolean newValue) {
                if (oldValue == null || !oldValue.equals(newValue)) {
                    FlowApplication.this.workspace.setVersionInfoVisible(newValue);
                }
            }
        });
        PVBoolean versionInTreePref = this.preferences.getPVBoolean(FlowApplicationPref.SHOW_VERSION_IN_TREE);
        versionInTreePref.addPreferenceListener(new PreferenceListener<Boolean>(){

            @Override
            public void valueChanged(Boolean oldValue, Boolean newValue) {
                if (oldValue == null || !oldValue.equals(newValue)) {
                    FlowApplication.this.reloadAlgorithmTree();
                }
            }
        });
        PVBoolean autoCreateLinksPref = this.preferences.getPVBoolean(FlowApplicationPref.AUTO_CREATE_LINKS);
        autoCreateLinksPref.addPreferenceListener(new PreferenceListener<Boolean>(){

            @Override
            public void valueChanged(Boolean oldValue, Boolean newValue) {
                if (oldValue == null || !oldValue.equals(newValue)) {
                    FlowApplication.this.workspace.setAutoCreateLinks(newValue);
                }
            }
        });
        PVBoolean saveBeforeExecutePref = this.preferences.getPVBoolean(FlowApplicationPref.SAVE_GRAPH_BEFORE_EXECUTE);
        saveBeforeExecutePref.addPreferenceListener(new PreferenceListener<Boolean>(){

            @Override
            public void valueChanged(Boolean oldValue, Boolean newValue) {
                if (oldValue == null || !oldValue.equals(newValue)) {
                    FlowApplication.this.saveBeforeExecute = newValue;
                }
            }
        });
        PVList favoriteAlgorithmPref = FlowApplication.getFavorites();
        favoriteAlgorithmPref.addPreferenceListener(new PreferenceListener<List<String>>(){

            @Override
            public void valueChanged(List<String> oldValue, List<String> newValue) {
                FlowApplication.this.reloadAlgorithmTree();
            }
        });
    }

    private void initAlgorithmsAndCategoriesUpdateFields() {
        this.modifiedAlgorithms = new Vector<AlgorithmInfo>();
        this.modifiedCategories = new Vector<Category>();
        this.algorithmRepositoryReloaded = false;
    }

    private void addAlgorithmProxyListener() {
        AlgorithmManagementProxy.addManagementListener(new AlgorithmManagementListener(){

            @Override
            public void categoryRemoved(Category category) {
                FlowApplication.this.modifiedCategories.add(category);
                this.enableAlgTreeRefreshDetailButtonItem();
            }

            @Override
            public void categoryCreated(Category category) {
                FlowApplication.this.modifiedCategories.add(category);
                this.enableAlgTreeRefreshDetailButtonItem();
            }

            @Override
            public void categoryUpdated(CategorySet modifiedCategorySet) {
                if (modifiedCategorySet != null) {
                    SortedSet categories = modifiedCategorySet.getCategories();
                    for (Category category : categories) {
                        FlowApplication.this.modifiedCategories.add(modifiedCategorySet.getCategory(category.getId()));
                    }
                    if (!categories.isEmpty()) {
                        this.enableAlgTreeRefreshDetailButtonItem();
                    }
                }
            }

            @Override
            public void algorithmCreated(AlgorithmInfo algoInfo) {
                FlowApplication.this.modifiedAlgorithms.add(algoInfo);
                this.enableAlgTreeRefreshDetailButtonItem();
            }

            @Override
            public void algorithmRemoved(AlgorithmInfo algoInfo) {
                FlowApplication.this.modifiedAlgorithms.add(algoInfo);
                this.enableAlgTreeRefreshDetailButtonItem();
            }

            @Override
            public void algorithmUpdated(AlgorithmInfo algoInfo) {
                FlowApplication.this.modifiedAlgorithms.add(algoInfo);
                this.enableAlgTreeRefreshDetailButtonItem();
            }

            @Override
            public void algorithmsReloaded() {
                FlowApplication.this.algorithmRepositoryReloaded = true;
                this.enableAlgTreeRefreshDetailButtonItem();
            }

            private void enableAlgTreeRefreshDetailButtonItem() {
                Runnable handler = new Runnable(){

                    @Override
                    public void run() {
                        FlowApplication.this.algTreeRefreshDetail.setEnabled(true);
                    }
                };
                if (SwingThreadDispatcher.isEventDispatchThread()) {
                    handler.run();
                } else {
                    SwingThreadDispatcher.invokeLater((Runnable)handler);
                }
            }
        });
    }

    public SortedSet<Category> getCategories() {
        Comparator<Category> c = new Comparator<Category>(){

            @Override
            public int compare(Category o1, Category o2) {
                if (o1.getId().equals(FlowApplication.FAVORITE_CATEGORY_ID)) {
                    return 0;
                }
                if (o2.getId().equals(FlowApplication.FAVORITE_CATEGORY_ID)) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<Category> categories = new TreeSet<Category>(c);
        CategorySet categorySet = AlgorithmManagementProxy.getAllCategories(this.getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
        categories.add(this.getFavoriteAlgorithmsCategory());
        categories.addAll(categorySet.getCategories());
        this.filterNotEmptyCategories(categories.iterator());
        return categories;
    }

    private Category getFavoriteAlgorithmsCategory() {
        Category favoritesCategory = new Category(FAVORITE_CATEGORY_ID, LNG.get((String)"FavoriteAlgorithm.label"));
        List<AlgorithmInfo> favoriteAlgorithms = this.getFavoriteAlgorithms();
        for (AlgorithmInfo algorithm : favoriteAlgorithms) {
            favoritesCategory.addAlgorithm(algorithm);
        }
        return favoritesCategory;
    }

    public List<AlgorithmInfo> getFavoriteAlgorithms() {
        AlgorithmInfo[] allInfos = AlgorithmManagementProxy.getAllAlgorithmInfos(null, AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
        PVList pv = FlowApplication.getFavorites();
        List valuesIds = (List)pv.getValue();
        ArrayList<AlgorithmInfo> ids = new ArrayList<AlgorithmInfo>();
        for (String valueId : valuesIds) {
            AlgorithmInfo algorithm = FlowApplication.searchAlgorithmById(allInfos, valueId);
            if (algorithm == null) continue;
            ids.add(algorithm);
        }
        Collections.unmodifiableList(ids);
        return ids;
    }

    public static final AlgorithmInfo searchAlgorithmById(AlgorithmInfo[] allInfos, String id) {
        for (int i = 0; i < allInfos.length; ++i) {
            AlgorithmInfo info = allInfos[i];
            if (!info.getId().equals(id)) continue;
            return info;
        }
        return null;
    }

    public static final List<String> getFavoriteAlgorithmsIds() {
        AlgorithmInfo[] allInfos = AlgorithmManagementProxy.getAllAlgorithmInfos(null, AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
        PVList pv = FlowApplication.getFavorites();
        List valuesIds = (List)pv.getValue();
        ArrayList<String> ids = new ArrayList<String>();
        for (String valueId : valuesIds) {
            AlgorithmInfo algorithm = FlowApplication.searchAlgorithmById(allInfos, valueId);
            if (algorithm == null) continue;
            ids.add(valueId);
        }
        Collections.unmodifiableList(ids);
        return ids;
    }

    public static PVList getFavorites() {
        PreferenceManager pm = PreferenceManager.getInstance();
        PreferenceCategory root = pm.loadPreferences();
        PreferenceCategory pc = root.getCategory(DesktopPref.class);
        DesktopPref fav = DesktopPref.FAVORITE_ALGORITHMS;
        PVList pv = (PVList)pc.getPreference(fav);
        return pv;
    }

    private void filterNotEmptyCategories(Iterator<Category> categoryIterator) {
        while (categoryIterator.hasNext()) {
            boolean hasSubCatNotEmpty;
            SortedSet subCategories;
            Category category = categoryIterator.next();
            if (!category.getAlgorithms().isEmpty() || (subCategories = category.getCategories()) != null && (hasSubCatNotEmpty = this.verifyAnySubCategoryContainsAlgorithms(subCategories.iterator())) || !category.getAlgorithms().isEmpty()) continue;
            categoryIterator.remove();
        }
    }

    private boolean verifyAnySubCategoryContainsAlgorithms(Iterator<Category> categoryIterator) {
        boolean hasAlgorithms = false;
        while (categoryIterator.hasNext()) {
            Category category = categoryIterator.next();
            if (!category.getAlgorithms().isEmpty()) {
                hasAlgorithms = true;
                return hasAlgorithms;
            }
            SortedSet subCategories = category.getCategories();
            Iterator<Category> subCatIterator = subCategories.iterator();
            hasAlgorithms = this.verifyAnySubCategoryContainsAlgorithms(subCatIterator);
        }
        return hasAlgorithms;
    }

    public SortedSet<AlgorithmInfo> getAlgorithms() {
        AlgorithmInfo[] algorithmInfos = AlgorithmManagementProxy.getAllAlgorithmInfos(this.getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
        TreeSet<AlgorithmInfo> uncategorizedAlgorithms = new TreeSet<AlgorithmInfo>();
        uncategorizedAlgorithms.addAll(Arrays.asList(algorithmInfos));
        SortedSet<Category> categories = this.getCategories();
        for (Category category : categories) {
            Iterator algorithmIterator = uncategorizedAlgorithms.iterator();
            while (algorithmIterator.hasNext()) {
                if (!category.containsAlgorithmInChildren((AlgorithmInfo)algorithmIterator.next())) continue;
                algorithmIterator.remove();
            }
        }
        return uncategorizedAlgorithms;
    }

    private JPanel createAlgorithmTreePanel(boolean showVersions) {
        final AlgorithmItemFilter filter = new AlgorithmItemFilter();
        this.algorithmsTree = new Tree((Node)new AllCategoryTreeNode(this.getCategories(), this.getAlgorithms(), showVersions), (Filter)filter);
        this.algorithmFilterPanel = new AlgorithmFilterParamPanel();
        this.algorithmFilterPanel.addListener(new AlgorithmFilterParamPanelListener(){

            @Override
            public void panelChanged(boolean ignoreCase, boolean useRegex, boolean showSimple, boolean showFlow, String text) {
                AlgorithmInfoFilterOperator operator = new AlgorithmInfoFilterOperator(ignoreCase, useRegex, showSimple, showFlow, text);
                filter.setParamters(operator);
                FlowApplication.this.algorithmsTree.filter();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.algorithmFilterPanel, "North");
        panel.add((Component)new JScrollPane((Component)this.algorithmsTree, 22, 32), "Center");
        this.algorithmFilterPanel.updateState();
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer((Component)this.algorithmsTree, 1, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                AlgorithmVersionInfo version = FlowApplication.this.getSelectedAlgorithmVersion();
                if (version != null) {
                    dge.startDrag(null, new AlgorithmVersionTransferable(version));
                }
            }
        });
        this.algorithmsTree.getSelectionModel().setSelectionMode(1);
        this.algorithmsTree.setToggleClickCount(0);
        this.algorithmsTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed() && SwingUtilities.isLeftMouseButton(e)) {
                    AlgorithmVersionInfo version = FlowApplication.this.getSelectedAlgorithmVersion();
                    if (version != null) {
                        FlowApplication.this.workspace.addNewNode(version);
                    }
                } else if (SwingUtilities.isRightMouseButton(e) && e.isPopupTrigger()) {
                    TreePath path = FlowApplication.this.algorithmsTree.getPathForLocation(e.getX(), e.getY());
                    FlowApplication.this.algorithmsTree.setSelectionPath(path);
                    FlowApplication.this.createContextTreeMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.isPopupTrigger()) {
                    TreePath path = FlowApplication.this.algorithmsTree.getPathForLocation(e.getX(), e.getY());
                    FlowApplication.this.algorithmsTree.setSelectionPath(path);
                    FlowApplication.this.createContextTreeMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        panel.setPreferredSize(new Dimension(300, 800));
        return panel;
    }

    private JPopupMenu createContextTreeMenu() {
        JPopupMenu popup = new JPopupMenu();
        AlgorithmVersionInfo version = this.getSelectedAlgorithmVersion();
        this.helpAction.setAlgorithmVersionInfo(version);
        JMenuItem openHelpItem = new JMenuItem(this.helpAction);
        popup.add(openHelpItem);
        AlgorithmInfo info = this.getSelectedAlgorithm();
        if (info != null) {
            if (this.isFavoriteApplication(info)) {
                this.removeFavoriteAction.setAlgorithmInfo(info);
                JMenuItem removeFavoriteItem = new JMenuItem(this.removeFavoriteAction);
                popup.add(removeFavoriteItem);
            } else {
                this.addFavoriteAction.setAlgorithmInfo(info);
                JMenuItem addFavoriteItem = new JMenuItem(this.addFavoriteAction);
                popup.add(addFavoriteItem);
            }
        }
        return popup;
    }

    public final boolean isFavoriteApplication(AlgorithmInfo info) {
        List<AlgorithmInfo> infos = this.getFavoriteAlgorithms();
        return infos.contains(info);
    }

    private AlgorithmFavoriteAddAction createAlgorithmFavoriteAddAction() {
        AlgorithmFavoriteAddAction action = new AlgorithmFavoriteAddAction(this);
        action.putValue("Name", this.getString("tree.addFavoriteMenu"));
        return action;
    }

    private AlgorithmFavoriteRemoveAction createAlgorithmFavoriteRemoveAction() {
        AlgorithmFavoriteRemoveAction action = new AlgorithmFavoriteRemoveAction(this);
        action.putValue("Name", this.getString("tree.removeFavoriteMenu"));
        return action;
    }

    private AlgorithmHelpAction createAlgorithmHelpAction() {
        AlgorithmHelpAction action = new AlgorithmHelpAction(this.getApplicationFrame());
        action.putValue("SmallIcon", ApplicationImages.ICON_HELP_16);
        action.putValue("Name", this.getString("tree.helpMenu"));
        return action;
    }

    public void requestFocusToAlgorithmComponent() {
        this.algorithmFilterPanel.getTextField().requestFocus();
    }

    public void reloadAlgorithmTree() {
        this.initAlgorithmsAndCategoriesUpdateFields();
        Runnable reloadHandler = new Runnable(){

            @Override
            public void run() {
                FlowApplication.this.clearStatusBarMessage();
                FlowApplication.this.horizontalSplitPane.remove(FlowApplication.this.algorithmsPanel);
                Boolean showVersionInTree = FlowApplication.this.preferences.getPreferenceAsBoolean(FlowApplicationPref.SHOW_VERSION_IN_TREE);
                FlowApplication.this.algorithmsPanel = FlowApplication.this.createAlgorithmTreePanel(showVersionInTree);
                FlowApplication.this.horizontalSplitPane.setLeftComponent(FlowApplication.this.algorithmsPanel);
                FlowApplication.this.algTreeRefreshDetail.setEnabled(false);
            }
        };
        if (SwingThreadDispatcher.isEventDispatchThread()) {
            reloadHandler.run();
        } else {
            SwingThreadDispatcher.invokeLater((Runnable)reloadHandler);
        }
        if (this.listOutdatedFlowsAction != null) {
            this.listOutdatedFlowsAction.updateToReload();
        }
    }

    public void askForParameterValues() {
        PickGraphMessage pickGraphMessage = new PickGraphMessage();
        this.workspace.sendVO((TypeMessage)pickGraphMessage);
        Graph graph = pickGraphMessage.getGraph();
        for (GraphNode node : graph.getNodeCollection()) {
            if (!node.isSelected()) continue;
            node.askForParameterValues();
        }
    }

    public void clearStatusBarMessage() {
        this.statusBar.clearStatus();
    }

    public boolean closeGraph() {
        return this.createNewGraph();
    }

    public boolean createNewGraph() {
        if (!this.userCanKillApplication()) {
            return false;
        }
        this.setGraph(new Graph(this.getApplicationFrame()), null);
        return true;
    }

    public boolean editConfigurator(final FlowAlgorithmConfigurator configurator, final String cmdDescription) {
        FlowApplicationRemoteTask<Void> task = new FlowApplicationRemoteTask<Void>(){

            protected void performTask() throws Exception {
                Flow flow = configurator.getFlow();
                Graph graph = new Graph(FlowApplication.this.getApplicationFrame(), flow);
                String description = cmdDescription != null ? cmdDescription : flow.getDescription();
                FlowApplication.this.setGraph(graph, description);
            }
        };
        if (task.execute(this.getApplicationFrame(), "Editando fluxo", "Carregando informa\u00e7\u00f5es do fluxo.")) {
            this.updateApplicationTitle();
            return true;
        }
        return false;
    }

    public void executeFlow(FlowAlgorithmConfigurator configurator) {
        CommandExecutionDialog commandExecutionDialog = new CommandExecutionDialog(this.getApplicationFrame(), (AlgorithmConfigurator)configurator, this.getApplicationProject());
        commandExecutionDialog.addCommandRequestedListener(new CommandRequestedListener(){

            @Override
            public void commandsWereRequested(Set<CommandInfo> submittedCommands) {
                for (CommandInfo command : submittedCommands) {
                    FlowApplication.this.commandIds.add(command.getId());
                }
            }
        });
        this.addExternalListeners(commandExecutionDialog);
        commandExecutionDialog.setVisible(true);
    }

    public void executeMultipleFlow(FlowAlgorithmConfigurator configurator, String[][] mappings) {
        MultipleFlowCommandExecutionDialog commandExecutionDialog = new MultipleFlowCommandExecutionDialog(this.getApplicationFrame(), configurator, this.getApplicationProject(), mappings);
        commandExecutionDialog.addCommandRequestedListener(new CommandRequestedListener(){

            @Override
            public void commandsWereRequested(Set<CommandInfo> submittedCommands) {
                for (CommandInfo command : submittedCommands) {
                    FlowApplication.this.commandIds.add(command.getId());
                }
            }
        });
        this.addExternalListeners(commandExecutionDialog);
        commandExecutionDialog.setVisible(true);
    }

    public void setGraph(Graph graph, String cmdDescription) {
        this.workspace.setGraph(graph);
        this.setCommandDescription(cmdDescription);
    }

    public void setCommandDescription(String commandDescription) {
        this.descriptionTextField.setText(commandDescription);
    }

    private void addExternalListeners(CommandExecutionDialog commandExecutionDialog) {
        for (CommandRequestedListener listener : this.listeners) {
            commandExecutionDialog.addCommandRequestedListener(listener);
        }
    }

    public void addCommandRequestedListener(CommandRequestedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public void killApplication() {
        this.commandIds.clear();
        MessageProxy.removeListener(this.commandPersistenceListener);
        this.commandViewerPanel.stop();
        this.keyFocusManager.removeKeyEventDispatcher(this.keyDispatcher);
        clipboard.removeFlavorListener(this.pasteAction);
    }

    public boolean openGraph() {
        try {
            if (!this.userCanKillApplication()) {
                return true;
            }
            ClientProjectFile file = this.browseFileOpen(this.getDefaultFileType());
            if (file != null) {
                this.load(file);
            }
            return true;
        }
        catch (ApplicationException e) {
            this.showExceptionStack(e);
            return false;
        }
    }

    public void removeSelectedElements() {
        this.workspace.sendVO((TypeMessage)new RemoveElementsMessage());
        this.workspace.sendVO((TypeMessage)new ResetMessage());
    }

    public boolean saveAsGraph() {
        try {
            ClientProjectFile file = this.browseFileSave(this.getDefaultFileType());
            if (file != null && this.save(file)) {
                this.currentFilePath = new ProjectTreePath(file);
                this.updateApplicationTitle();
                return true;
            }
        }
        catch (ApplicationException e) {
            this.showExceptionStack(e);
        }
        return false;
    }

    public boolean saveGraph() {
        if (this.currentFilePath == null) {
            return this.saveAsGraph();
        }
        return this.save(this.currentFilePath.getFile());
    }

    public boolean hasToSaveBeforeExecute() {
        return this.wasChanged && this.saveBeforeExecute;
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (value != null) {
            if (name.equals("PROJECT_FILE")) {
                ClientProjectFile file = (ClientProjectFile)value;
                this.load(file);
                return;
            }
            if (name.equals(CONFIGURATOR_MESSAGE)) {
                AlgorithmConfigurator algorithmConfigurator = (AlgorithmConfigurator)value;
                this.workspace.importConfigurator(algorithmConfigurator);
            }
        }
        super.sendMessage(name, value, senderId);
    }

    public void setStatusBarMessage(String message) {
        this.statusBar.setText(message);
    }

    public void showParameterValues() {
        this.workspace.sendVO((TypeMessage)new ShowParameterValuesMessage());
    }

    @Override
    public void startApplication() throws ApplicationException {
        super.startApplication();
        this.updateApplicationTitle();
        this.commandViewerPanel.start();
        MessageProxy.addListener(this.commandPersistenceListener, CommandPersistenceNotification.class);
        this.commandIds.clear();
    }

    @Override
    protected boolean userCanKillApplication() {
        if (this.wasChanged) {
            switch (StandardDialogs.showYesNoCancelDialog((Component)this.getApplicationFrame(), (String)this.getName(), (Object)this.getString("askForSaving"))) {
                case -1: 
                case 2: {
                    return false;
                }
                case 0: {
                    if (this.saveGraph()) break;
                    return false;
                }
            }
        }
        this.currentFilePath = null;
        this.updateApplicationTitle();
        this.workspace.sendVO((TypeMessage)new ResetMessage());
        return true;
    }

    private void createActions() {
        this.closeAction = new CloseAction(this);
        this.executeAction = new ExecuteGraphAction(this);
        this.exportMultipleConfigurationAction = new ExportMultipleConfigurationAction(this);
        this.multipleExecuteAction = new MultipleExecuteGraphAction(this);
        this.loadAction = new LoadAction(this);
        this.newAction = new NewAction(this);
        this.removeAction = new RemoveElementsAction(this);
        this.saveAction = new SaveAction(this);
        this.saveAsAction = new SaveAsAction(this);
        this.showPropertiesAction = new ShowParameterValuesAction(this);
        this.updateVersionsAction = new UpdateAllVersionsAction(this);
        this.updateAlgorithmTreeAction = new UpdateAlgorithmTreeAction(this);
        this.listOutdatedFlowsAction = new ListOutdatedFlowsAction(this);
        this.zoomControl = new ZoomControl(this.workspace.getZoomModel());
        this.copyAction = new CopyElementsAction(this);
        this.pasteAction = new PasteElementsAction(this);
        this.helpAction = this.createAlgorithmHelpAction();
        this.addFavoriteAction = this.createAlgorithmFavoriteAddAction();
        this.removeFavoriteAction = this.createAlgorithmFavoriteRemoveAction();
    }

    private CommandPropertiesFilter createCommandPropertiesFilter() {
        return new CommandPropertiesFilter(){

            @Override
            public boolean accept(CommandInfo command) {
                return FlowApplication.this.commandIds.contains(command.getId());
            }
        };
    }

    private JMenu createEditMenu() {
        JMenu editMenu = new JMenu(this.getString("editMenu"));
        int key = ClientKeyStrokeUtil.getKey(this.getString("editMenu.mnemonic"));
        editMenu.setMnemonic(key);
        editMenu.add(new JMenuItem(this.askForParameterValuesFilter.getAction()));
        editMenu.addSeparator();
        editMenu.add(new JMenuItem(this.copyAction));
        editMenu.add(new JMenuItem(this.pasteAction));
        editMenu.addSeparator();
        editMenu.add(new JMenuItem(this.removeAction));
        editMenu.addSeparator();
        editMenu.add(new JMenuItem(this.updateVersionsAction));
        return editMenu;
    }

    private JMenu createExecuteMenu() {
        JMenu executeMenu = new JMenu(this.getString("executeMenu"));
        int key = ClientKeyStrokeUtil.getKey(this.getString("executeMenu.mnemonic"));
        executeMenu.setMnemonic(key);
        executeMenu.add(new JMenuItem(this.executeAction));
        executeMenu.add(new JMenuItem(this.multipleExecuteAction));
        executeMenu.add(new JMenuItem(this.exportMultipleConfigurationAction));
        return executeMenu;
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu(this.getString("fileMenu"));
        int key = ClientKeyStrokeUtil.getKey(this.getString("fileMenu.mnemonic"));
        fileMenu.setMnemonic(key);
        fileMenu.add(new JMenuItem(this.newAction));
        fileMenu.add(new JMenuItem(this.loadAction));
        fileMenu.add(new JMenuItem(this.closeAction));
        fileMenu.add(new JMenuItem(this.saveAction));
        fileMenu.add(new JMenuItem(this.saveAsAction));
        fileMenu.add(new JMenuItem(this.updateAlgorithmTreeAction));
        User loggedUser = User.getLoggedUser();
        if (loggedUser != null && loggedUser.isAdmin()) {
            fileMenu.add(new JMenuItem(this.listOutdatedFlowsAction));
        }
        fileMenu.addSeparator();
        fileMenu.add(new ApplicationExitAction(this));
        return fileMenu;
    }

    private void createFilters() {
        this.askForParameterValuesFilter = new AskForParameterValuesActionFilter(new AskForParameterValuesAction(this), this.workspace);
        this.basicPopupFilter = new PopupFilter(this.workspace);
        this.copyAndPasteFilter = new CopyAndPasteFilter(clipboard, this.workspace);
        this.hightLightFilter = new HighlightElementFilter(this.workspace);
        this.hintFilter = new HintElementFilter(this.workspace);
        this.resizeNodeFilter = new ResizeNodeFilter(this.workspace);
        this.selectElementFilter = new SelectElementFilter(this.workspace);
        this.updateStatusBarFilter = new UpdateStatusBarFilter(this);
        this.createPopupFilters();
    }

    private void createGui() {
        this.createActions();
        clipboard.addFlavorListener(this.pasteAction);
        ApplicationFrame mainFrame = this.getApplicationFrame();
        mainFrame.setJMenuBar(this.createMenuBar());
        mainFrame.getContentPane().add((Component)this.createToolBar(), "North");
        mainFrame.getContentPane().add((Component)this.createMainComponent(), "Center");
        mainFrame.getContentPane().add((Component)this.createStatusBarPanel(), "South");
        mainFrame.setSize(DesktopFrame.getInstance().getDesktopFrame().getSize());
        mainFrame.showStatusBar();
        this.updateApplicationTitle();
        this.createKeyAccelerators(mainFrame);
    }

    private void createKeyAccelerators(ApplicationFrame mainFrame) {
        JRootPane rootPane = mainFrame.getRootPane();
        InputMap inputMap = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("control F"), "setFocusAlgTree");
        actionMap.put("setFocusAlgTree", new AlgorithmComponentFocusAction(this));
    }

    private JComponent createMainComponent() {
        this.horizontalSplitPane = new JSplitPane(1);
        this.horizontalSplitPane.setLeftComponent(this.algorithmsPanel);
        this.horizontalSplitPane.setRightComponent(this.workspaceScrollPane);
        this.horizontalSplitPane.setOneTouchExpandable(true);
        this.horizontalSplitPane.setResizeWeight(0.0);
        this.horizontalSplitPane.resetToPreferredSizes();
        JSplitPane verticalSplitPane = new JSplitPane(0);
        verticalSplitPane.setTopComponent(this.horizontalSplitPane);
        verticalSplitPane.setBottomComponent(this.commandViewerPanel);
        verticalSplitPane.setOneTouchExpandable(true);
        verticalSplitPane.setResizeWeight(1.0);
        verticalSplitPane.setDividerLocation(0.75);
        return verticalSplitPane;
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu(this.getString("helpMenu"));
        helpMenu.add(new ApplicationAboutAction(this));
        int key = ClientKeyStrokeUtil.getKey(this.getString("helpMenu.mnemonic"));
        helpMenu.setMnemonic(key);
        return helpMenu;
    }

    private JMenu createPreferencesMenu() {
        ApplicationEditPrefAction preferencesAction = new ApplicationEditPrefAction(this, this.preferences);
        JMenuItem item = new JMenuItem(preferencesAction);
        JMenu preferencesMenu = new JMenu(this.getString("preferencesMenu"));
        int key = ClientKeyStrokeUtil.getKey(this.getString("preferencesMenu.mnemonic"));
        preferencesMenu.setMnemonic(key);
        preferencesMenu.add(item);
        return preferencesMenu;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createViewMenu());
        menuBar.add(this.createExecuteMenu());
        menuBar.add(this.createPreferencesMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    private void createPopupFilters() {
        this.popupFilters = Arrays.asList(csbase.client.applications.flowapplication.graph.actions.AskForParameterValuesAction.createFilter(this.workspace), csbase.client.applications.flowapplication.graph.actions.ShowParameterValuesAction.createFilter(this.workspace), CopyParameterValuesAction.createFilter(this.workspace), PasteParameterValuesAction.createFilter(this.workspace), CopySelectedElementsAction.createFilter(this.workspace), PasteSelectedElementsAction.createFilter(this.workspace), BreakLinkAction.createFilter(this.workspace), RemoveSelectedElementsAction.createFilter(this.workspace), UpdateVersionAction.createFilter(this.workspace), BypassAction.createFilter(this.workspace), ShowAlgorithmHelpAction.createFilter(this.workspace));
    }

    private JPanel createStatusBarPanel() {
        JPanel statusBarPanel = new JPanel(new BorderLayout());
        this.statusBar = this.getApplicationFrame().getStatusBar();
        statusBarPanel.add((Component)this.statusBar, "Center");
        return statusBarPanel;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(BorderFactory.createEtchedBorder());
        toolBar.addSeparator();
        JButton executeButton = new JButton(this.executeAction);
        JButton loadButton = new JButton(this.loadAction);
        JButton newButton = new JButton(this.newAction);
        JButton removeButton = new JButton(this.removeAction);
        JButton saveButton = new JButton(this.saveAction);
        this.refreshMenuButton = this.makeRefreshMenuButton();
        JButton updateVersionsButton = new JButton(this.updateVersionsAction);
        JButton showParameterButton = new JButton(this.askForParameterValuesFilter.getAction());
        JButton showPropertiesButton = new JButton(this.showPropertiesAction);
        MenuButton layoutButton = this.createLayoutMenuButton();
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new GridBagLayout());
        JLabel descriptionLabel = new JLabel(this.getString("descriptionLabel"));
        this.descriptionTextField = new JTextField();
        this.descriptionTextField.setColumns(50);
        GBC gbc = new GBC(1, 1);
        gbc.insets(2);
        descriptionPanel.add((Component)descriptionLabel, gbc);
        descriptionPanel.add((Component)this.descriptionTextField, gbc.gridx(2).horizontal());
        executeButton.setText("");
        loadButton.setText("");
        newButton.setText("");
        removeButton.setText("");
        saveButton.setText("");
        this.refreshMenuButton.setText("");
        updateVersionsButton.setText("");
        showParameterButton.setText("");
        showPropertiesButton.setText("");
        toolBar.add(newButton);
        toolBar.add(loadButton);
        toolBar.add(saveButton);
        toolBar.add((Component)this.refreshMenuButton);
        toolBar.addSeparator();
        toolBar.add(removeButton);
        toolBar.addSeparator();
        toolBar.add(showPropertiesButton);
        toolBar.add(showParameterButton);
        toolBar.add(updateVersionsButton);
        toolBar.addSeparator();
        toolBar.add(executeButton);
        toolBar.addSeparator();
        toolBar.add(descriptionPanel);
        toolBar.addSeparator();
        toolBar.add((Component)layoutButton);
        toolBar.add(this.zoomControl);
        return toolBar;
    }

    private MenuButton createLayoutMenuButton() {
        MenuButton layoutButton = new MenuButton((Icon)FlowApplicationUI.GENERIC_LAYOUT_ICON, MenuButton.PopupPosition.BOTTOM);
        UniformSizeLayoutAction uniformLayoutAction = new UniformSizeLayoutAction(this);
        SingleColumnGraphLayoutAction singleColumnAction = new SingleColumnGraphLayoutAction(this);
        OrthogonalLinkLayoutAction linkLayoutAction = new OrthogonalLinkLayoutAction(this);
        layoutButton.add(new JMenuItem(singleColumnAction));
        layoutButton.add(new JMenuItem(uniformLayoutAction));
        layoutButton.add(new JMenuItem(linkLayoutAction));
        layoutButton.setToolTipText(this.getString("layoutButton"));
        return layoutButton;
    }

    private JMenu createViewMenu() {
        JMenu viewMenu = new JMenu(this.getString("viewMenu"));
        int key = ClientKeyStrokeUtil.getKey(this.getString("viewMenu.mnemonic"));
        viewMenu.setMnemonic(key);
        JMenuItem zoomInMenuItem = new JMenuItem(this.zoomControl.getZoomInAction());
        JMenuItem zoomOutMenuItem = new JMenuItem(this.zoomControl.getZoomOutAction());
        JMenuItem zoomFitMenuItem = new JMenuItem(this.zoomControl.getZoomFitAction());
        viewMenu.add(new JMenuItem(this.showPropertiesAction));
        viewMenu.addSeparator();
        viewMenu.add(zoomOutMenuItem);
        viewMenu.add(zoomInMenuItem);
        viewMenu.add(zoomFitMenuItem);
        return viewMenu;
    }

    private String getDefaultFileType() {
        List fileTypeVector = this.getApplicationRegistry().getFileTypes();
        if (fileTypeVector.isEmpty()) {
            return null;
        }
        return (String)fileTypeVector.get(0);
    }

    private AlgorithmVersionInfo getSelectedAlgorithmVersion() {
        TreePath treePath = this.algorithmsTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Node node = (Node)treePath.getLastPathComponent();
        if (node instanceof AlgorithmVersionTreeNode) {
            AlgorithmVersionTreeNode algorithmVersionTreeNode = (AlgorithmVersionTreeNode)node;
            return algorithmVersionTreeNode.getAlgorithmVersion();
        }
        if (node instanceof AlgorithmTreeNode) {
            AlgorithmTreeNode algorithmTreeNode = (AlgorithmTreeNode)node;
            AlgorithmInfo algorithmInfo = algorithmTreeNode.getAlgorithm();
            return algorithmInfo.getLastVersion();
        }
        return null;
    }

    private AlgorithmInfo getSelectedAlgorithm() {
        TreePath treePath = this.algorithmsTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Node node = (Node)treePath.getLastPathComponent();
        if (node instanceof AlgorithmTreeNode) {
            AlgorithmTreeNode algorithmTreeNode = (AlgorithmTreeNode)node;
            AlgorithmInfo algorithmInfo = algorithmTreeNode.getAlgorithm();
            return algorithmInfo;
        }
        return null;
    }

    private void load(final ClientProjectFile file) {
        this.currentFilePath = null;
        FlowApplicationRemoteTask<Void> task = new FlowApplicationRemoteTask<Void>(){

            protected void performTask() throws OperationFailureException, IOException, ParseException {
                InputStream inputStream = file.getInputStream();
                FlowAlgorithmParser parser = new FlowAlgorithmParser();
                Flow flow = parser.read(inputStream);
                Graph graph = new Graph(FlowApplication.this.getApplicationFrame(), flow);
                FlowApplication.this.setGraph(graph, flow.getDescription());
            }
        };
        String message = this.getString("loadingFile", new Object[]{file.getStringPath()});
        if (task.execute(this.getApplicationFrame(), message, message)) {
            this.currentFilePath = new ProjectTreePath(file);
            this.updateApplicationTitle();
        }
    }

    private boolean save(final ClientProjectFile file) {
        FlowApplicationRemoteTask<Void> task = new FlowApplicationRemoteTask<Void>(){

            @Override
            protected void handleError(Exception error) {
                if (error instanceof FileLockedException) {
                    StandardDialogs.showErrorDialog((Component)FlowApplication.this.getApplicationFrame(), (String)FlowApplication.this.getName(), (String)String.format(FlowApplication.this.getString("msg.error.file.locked"), file.getName()));
                } else {
                    super.handleError(error);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void performTask() throws Exception {
                Flow flow = FlowApplication.this.getWorkspace().getGraph().toFlow();
                flow.setName(file.getName());
                flow.setDescription(FlowApplication.this.descriptionTextField.getText());
                OutputStream outputStream = null;
                try {
                    outputStream = file.getOutputStream();
                    FlowAlgorithmParser parser = new FlowAlgorithmParser();
                    parser.write(outputStream, flow);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        String message = this.getString("savingFile", new Object[]{FileUtils.joinPath((char)'/', (String[])file.getPath())});
        if (task.execute(this.getApplicationFrame(), message, message)) {
            this.wasChanged = false;
            return true;
        }
        return false;
    }

    private void updateApplicationTitle() {
        String titleDetails;
        if (this.currentFilePath == null) {
            titleDetails = this.getString("without_file");
        } else {
            String currentFilePathAsString;
            ClientProjectFile currentFile = this.currentFilePath.getFile();
            titleDetails = currentFilePathAsString = currentFile.getStringPath();
        }
        this.getApplicationFrame().setTitle(titleDetails + " - " + this.getApplicationProject().getName() + " - " + this.getName());
    }

    public void hideAlgorithmTreePanel() {
        this.horizontalSplitPane.setDividerLocation(0.0);
    }

    public void showAlgorithmTreePanel() {
        this.horizontalSplitPane.setDividerLocation(this.horizontalSplitPane.getMinimumDividerLocation());
    }

    private MenuButton makeRefreshMenuButton() {
        if (this.refreshMenuButton == null) {
            this.refreshMenuButton = new MenuButton((Icon)ApplicationImages.ICON_REFRESH_THIN_16, MenuButton.PopupPosition.BOTTOM);
            this.createRefreshButtonItems();
            String tooltip = this.getString("button.refresh.tooltip");
            this.refreshMenuButton.setToolTipText(tooltip);
            this.algTreeRefreshDetail.setEnabled(false);
        }
        return this.refreshMenuButton;
    }

    private void createRefreshButtonItems() {
        if (this.refreshMenuButton == null) {
            return;
        }
        JMenuItem updateAlgoItem = new JMenuItem(this.getString("popup.menu.item.refresh"));
        updateAlgoItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FlowApplication.this.reloadAlgorithmTree();
            }
        });
        this.algTreeRefreshDetail = new JMenuItem(this.getString("popup.menu.item.detail"));
        this.algTreeRefreshDetail.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String algoChanges = FlowApplication.this.getString("msg.update.algorithms", new Object[]{FlowApplication.this.modifiedAlgorithms.size()});
                String categoriesChanges = FlowApplication.this.getString("msg.update.categories", new Object[]{FlowApplication.this.modifiedCategories.size()});
                String changes = algoChanges + " / " + categoriesChanges;
                if (FlowApplication.this.algorithmRepositoryReloaded) {
                    String repositoryReloaded;
                    changes = repositoryReloaded = FlowApplication.this.getString("msg.update.repository.reloaded");
                }
                FlowApplication.this.setStatusBarMessage(changes);
            }
        });
        this.refreshMenuButton.add(updateAlgoItem);
        this.refreshMenuButton.addSeparator();
        this.refreshMenuButton.add(this.algTreeRefreshDetail);
    }

    public String getFlowName() {
        String flowName;
        if (this.currentFilePath == null) {
            flowName = this.getString("anonymous");
        } else {
            ClientProjectFile currentFile = this.currentFilePath.getFile();
            String currentFilePathAsString = currentFile.getStringPath();
            flowName = this.wasChanged ? this.getString("flowModified", new Object[]{currentFilePathAsString}) : currentFilePathAsString;
        }
        return flowName;
    }

    public String getFlowDescription() {
        return this.descriptionTextField.getText();
    }

    private class AlgorithmItemFilter
    implements Filter {
        private AlgorithmInfoFilterOperator operator;

        private AlgorithmItemFilter() {
        }

        void setParamters(AlgorithmInfoFilterOperator operator) {
            this.operator = operator;
        }

        public boolean isAccepted(Node node) {
            AlgorithmInfo info = null;
            if (node instanceof AlgorithmVersionTreeNode) {
                AlgorithmVersionTreeNode algorithmVersionTreeNode = (AlgorithmVersionTreeNode)node;
                info = algorithmVersionTreeNode.getAlgorithmVersion().getInfo();
            } else if (node instanceof AlgorithmTreeNode) {
                AlgorithmTreeNode algorithmTreeNode = (AlgorithmTreeNode)node;
                info = algorithmTreeNode.getAlgorithm();
            }
            if (info == null) {
                return false;
            }
            return this.operator.accept(info);
        }

        public boolean isEnabled() {
            return this.operator != null;
        }
    }

    private final class ChangedListener
    implements GraphListener {
        private ChangedListener() {
        }

        @Override
        public void wasChangedWorkspace(Graph graph) {
        }

        @Override
        public void wasElementCreated(Graph graph, GraphElement element) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasElementDragged(Graph graph, GraphElement element, double tx, double ty) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasElementDragged(Graph graph, GraphElement element, Point2D startPoint, Point2D endPoint) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasElementDropped(Graph graph, GraphElement element, Point2D point) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasElementParametrized(Graph graph, GraphElement element) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasElementRemoved(Graph graph, GraphElement element) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasElementSelected(Graph graph, GraphElement element) {
            if (element != null) {
                Rectangle2D rectangle = element.getBounds2D();
                FlowApplication.this.workspace.scrollRectToVisible(rectangle.getBounds());
            }
        }

        @Override
        public void wasLinkAnchored(Graph graph, GraphLink link, GraphFileDescriptor fileDescriptor) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasLinkIncreased(Graph graph, GraphLink link) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasLinkStatusChanged(Graph graph, GraphLink link) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasLinkUnanchored(Graph graph, GraphLink link, GraphFileDescriptor fileDescriptor) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasNodeResized(Graph graph, GraphNode node) {
            FlowApplication.this.wasChanged = true;
        }

        @Override
        public void wasParameterSetEnabled(Graph graph, GraphNode node, String parameterName, boolean isEnabled) {
        }

        @Override
        public void wasParameterSetVisible(Graph graph, GraphNode node, String parameterName, boolean isVisible) {
        }

        @Override
        public void wasReseted(Graph graph) {
        }
    }

    private final class FlowApplicationKeyDispatcher
    implements KeyEventDispatcher {
        private FlowApplicationKeyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent event) {
            Object source = event.getSource();
            if (FlowApplication.this.horizontalSplitPane.isAncestorOf((Component)source) && !event.isAltDown() && !event.isControlDown()) {
                int keyCode = event.getKeyCode();
                switch (keyCode) {
                    case 10: {
                        if (event.getID() == 401) {
                            AlgorithmVersionInfo version = FlowApplication.this.getSelectedAlgorithmVersion();
                            if (version != null) {
                                FlowApplication.this.workspace.addNewNode(version);
                            }
                            return true;
                        }
                    }
                    case 38: 
                    case 40: {
                        JTextField field = FlowApplication.this.algorithmFilterPanel.getTextField();
                        field.selectAll();
                        FlowApplication.this.keyFocusManager.redispatchEvent((Component)FlowApplication.this.algorithmsTree, event);
                        return true;
                    }
                }
                if (Character.isLetterOrDigit(event.getKeyChar())) {
                    JTextField textField = FlowApplication.this.algorithmFilterPanel.getTextField();
                    textField.requestFocusInWindow();
                    FlowApplication.this.keyFocusManager.redispatchEvent(textField, event);
                    return true;
                }
            }
            return false;
        }
    }
}

