/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.dialogs;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.dialogs.ProjectBuildingDialog;
import csbase.client.project.dialogs.ProjectDataExtensionPanel;
import csbase.logic.CommonClientProject;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

class ProjectUpdateDialog
extends ProjectBuildingDialog {
    ProjectUpdateDialog(Window owner, CommonClientProject project, ProjectDataExtensionPanel extraPanel) {
        super(owner, project, extraPanel);
        this.fillDialog();
    }

    private void fillDialog() {
        this.nameField.setText(this.project.getName());
        this.nameField.setEnabled(false);
        this.descrField.setText(this.project.getDescription());
        this.projectOwnerField.setText(String.valueOf(this.project.getUserId()));
        this.searchButton.setEnabled(false);
        long lockingAreaSize = this.project.getLockingAreaSize();
        if (lockingAreaSize > 0L) {
            this.lockingBox.setSelected(true);
            this.sizeField.setEnabled(false);
            this.sizeField.setText(String.valueOf(lockingAreaSize));
        }
        this.lockingBox.setEnabled(false);
    }

    private void updateProject() {
        String description = this.descrField.getText();
        this.updateProject(this.getOwner(), this.project, description);
        this.dispose();
    }

    private void updateProject(Window window, final CommonClientProject ccp, String description) {
        ccp.setDescription(description);
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                ccp.modify();
            }
        };
        if (task.execute(window, this.getTitle(), LNG.get((String)"ProjectUpdateDialog.waiting.update.message"))) {
            StandardDialogs.showInfoDialog((Component)window, (String)this.getTitle(), (Object)LNG.get((String)"ProjectUpdateDialog.update.success.message"));
        }
    }

    @Override
    public String getTitle() {
        return LNG.get((String)"ProjectUpdateDialog.update.title");
    }

    @Override
    void setOkButton(JButton confirmButton) {
        confirmButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectUpdateDialog.this.updateProject();
            }
        });
        confirmButton.setText(LNG.get((String)"ProjectUpdateDialog.update.button"));
    }
}

