/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.administration.AdministrationDeleteException;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.UserInfo;
import csbase.logic.UserOutline;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;

public class UserProxy {
    public static Vector<UserOutline> getAllOutlines(Window owner, String title, String message) {
        RemoteTask<Vector<UserOutline>> task = new RemoteTask<Vector<UserOutline>>(){

            public void performTask() throws Exception {
                this.setResult(new Vector(User.getAllOutlines()));
            }
        };
        if (task.execute(owner, title, message)) {
            Vector outlinesVector = (Vector)task.getResult();
            if (outlinesVector == null || outlinesVector.size() <= 0) {
                return new Vector<UserOutline>();
            }
            return outlinesVector;
        }
        return new Vector<UserOutline>();
    }

    public static Vector<User> getAllUsers(Window owner, String title, String message) {
        RemoteTask<Vector<User>> task = new RemoteTask<Vector<User>>(){

            public void performTask() throws Exception {
                this.setResult(new Vector(User.getAllUsers()));
            }
        };
        if (task.execute(owner, title, message)) {
            Vector usersVector = (Vector)task.getResult();
            if (usersVector == null || usersVector.size() <= 0) {
                return new Vector<User>();
            }
            return usersVector;
        }
        return new Vector<User>();
    }

    public static User getUser(Window owner, String title, String message, final Object userId) {
        RemoteTask<User> task = new RemoteTask<User>(){

            public void performTask() throws Exception {
                this.setResult(User.getUser((Object)userId));
            }
        };
        if (task.execute(owner, title, message)) {
            return (User)task.getResult();
        }
        return null;
    }

    public static User createUser(Window owner, String title, String message, final UserInfo info) {
        RemoteTask<User> task = new RemoteTask<User>(){

            public void performTask() throws Exception {
                this.setResult(User.createUser((UserInfo)info));
            }
        };
        if (task.execute(owner, title, message)) {
            User user = (User)task.getResult();
            if (user == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_USER_ALREADY_EXISTS_ERROR"));
            }
            return user;
        }
        return null;
    }

    public static ImageIcon getPhoto(Window owner, final Object userId) {
        RemoteTask<ImageIcon> task = new RemoteTask<ImageIcon>(){

            public void performTask() throws Exception {
                this.setResult(User.getPhoto((Object)userId));
            }
        };
        if (task.execute(owner, "", LNG.get((String)"IAS_PHOTO_WAITING"))) {
            ImageIcon img = (ImageIcon)task.getResult();
            if (img == null) {
                img = new ImageIcon();
            }
            return img;
        }
        return null;
    }

    public static User modifyUser(Window owner, String title, String message, final Object userId, final UserInfo info) {
        RemoteTask<User> task = new RemoteTask<User>(){

            public void performTask() throws Exception {
                this.setResult(User.modifyUser((Object)userId, (UserInfo)info));
            }
        };
        if (task.execute(owner, title, message)) {
            User user = (User)task.getResult();
            if (user == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_USER_NOT_FOUND_ERROR"));
            }
            return user;
        }
        return null;
    }

    public static void modifyUsers(Window owner, String title, String message, final List<User> users) {
        final ArrayList usersNotFound = new ArrayList();
        RemoteTask<User> task = new RemoteTask<User>(){

            public void performTask() throws Exception {
                for (User user : users) {
                    User modifiedUser = User.modifyUser((Object)user.getId(), (UserInfo)user.getUserInfo());
                    if (modifiedUser != null) continue;
                    usersNotFound.add(user);
                }
            }
        };
        task.execute(owner, title, message);
        if (usersNotFound.size() > 0) {
            String msg = "<html>";
            msg = msg + LNG.get((String)"IAS_USERS_NOT_FOUND_ERROR");
            for (int i = 0; i < usersNotFound.size(); ++i) {
                User user = (User)usersNotFound.get(i);
                msg = msg + user.getId();
                if (i > 200) break;
                if (i < usersNotFound.size() - 1) {
                    msg = msg + ", ";
                }
                if (i % 20 != 0 || i == 0) continue;
                msg = msg + "<br/>";
            }
            msg = msg + ".</html>";
            StandardErrorDialogs.showErrorDialog(owner, title, msg);
        }
    }

    public static void deleteUser(final Window owner, final String title, String message, final Object userId) {
        class DeleteUserTask
        extends RemoteTask<Void> {
            boolean removeProjects = false;

            DeleteUserTask() {
            }

            public void performTask() throws Exception {
                User.deleteUser((Object)userId);
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof AdministrationDeleteException) {
                    String errorMsg = LNG.get((String)"IAS_CONFIRM_USER_REMOVAL");
                    int res = JOptionPane.showOptionDialog(owner, errorMsg, title, 0, 2, null, new Object[]{LNG.get((String)"IAS_YES"), LNG.get((String)"IAS_NO")}, LNG.get((String)"IAS_NO"));
                    if (res == 0) {
                        this.removeProjects = true;
                    }
                } else {
                    super.handleError(error);
                }
            }
        }
        DeleteUserTask deleteTask = new DeleteUserTask();
        if (!deleteTask.execute(owner, title, message) && deleteTask.removeProjects) {
            RemoteTask<Boolean> rtask = new RemoteTask<Boolean>(){

                public void performTask() throws Exception {
                    boolean allRemoved;
                    boolean projectsRemoved = CommonClientProject.removeUserProjects((Object)userId);
                    boolean sharedRemoved = ClientRemoteLocator.sharedObjectService.removeUserData(userId);
                    boolean bl = allRemoved = projectsRemoved && sharedRemoved;
                    if (allRemoved) {
                        User.deleteUser((Object)userId);
                    }
                    this.setResult(allRemoved);
                }
            };
            rtask.execute(owner, title, message);
            if (!((Boolean)rtask.getResult()).booleanValue()) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_USER_PROJECTS_NOT_DELETED"));
            }
        }
    }
}

