/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.columns;

import csbase.client.util.csvpanel.columns.ColumnGenerator;

public class SequentialColumnGenerator
implements ColumnGenerator<String> {
    private int startValue;
    private int step;
    private String prefix;
    private String sufix;

    public SequentialColumnGenerator() {
        this(null, null);
    }

    public SequentialColumnGenerator(Integer startValue, Integer step) {
        this(startValue, step, null, null);
    }

    public SequentialColumnGenerator(Integer startValue, Integer step, String prefix, String suffix) {
        this.setStartValue(startValue);
        this.setStep(step);
        this.setPrefix(prefix);
        this.setSufix(suffix);
    }

    @Override
    public String getValueAt(int rowIndex) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.prefix);
        int value = this.startValue + rowIndex * this.step;
        builder.append(value);
        builder.append(this.sufix);
        return builder.toString();
    }

    public int getStartValue() {
        return this.startValue;
    }

    public int getStep() {
        return this.step;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSufix() {
        return this.sufix;
    }

    public void setStartValue(Integer startValue) {
        this.startValue = startValue == null ? 1 : startValue;
    }

    public void setStep(Integer step) {
        this.step = step == null ? 1 : step;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix == null ? "" : prefix;
    }

    public void setSufix(String sufix) {
        this.sufix = sufix == null ? "" : sufix;
    }
}

