/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.client.remote.RecentAlgorithmsListener;
import csbase.logic.SharedObject;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SharedObjectServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RecentAlgorithmsManager {
    private static final int MAX_ALGORITHMS = 5;
    private static final String RECENT_ALGORITHMS = "recent_algorithms";
    private static final String RECENT_ALGORITHMS_CATEGORY = "RecentAgorithms";
    private LinkedList<AlgorithmInfo> recentLocalAlgoritms;
    private boolean isLocal;
    public static List<RecentAlgorithmsListener> managementList = new ArrayList<RecentAlgorithmsListener>();

    public RecentAlgorithmsManager() {
        new RecentAlgorithmsManager(false);
    }

    public RecentAlgorithmsManager(boolean isLocal) {
        this.recentLocalAlgoritms = new LinkedList();
        this.isLocal = isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
        this.notifyAlgorithmUpdated();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    private SharedObject readSharedObject() throws RemoteException {
        SharedObjectServiceInterface sharedObjectService = ClientRemoteLocator.sharedObjectService;
        try {
            SharedObject sharedObject = sharedObjectService.getSharedObject(RECENT_ALGORITHMS_CATEGORY, User.getLoggedUser().getId(), RECENT_ALGORITHMS);
            return sharedObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    private LinkedList<AlgorithmInfo> getAlgorithmInfosFromSharedObject(SharedObject so) {
        LinkedList<AlgorithmInfo> algorithmHistoryInfos = new LinkedList<AlgorithmInfo>();
        if (so == null || so.getContents() == null) {
            return algorithmHistoryInfos;
        }
        algorithmHistoryInfos.addAll((Collection)so.getContents());
        return algorithmHistoryInfos;
    }

    public LinkedList<AlgorithmInfo> getAlgorithmInfosFromHistory() throws RemoteException {
        SharedObject so = this.readSharedObject();
        return this.getAlgorithmInfosFromSharedObject(so);
    }

    public List<AlgorithmInfo> getRecentAlgoritmsInfos() throws RemoteException {
        return Collections.unmodifiableList(this.getAlgoritmsInfos());
    }

    private LinkedList<AlgorithmInfo> getAlgoritmsInfos() throws RemoteException {
        if (!this.isLocal) {
            return this.getAlgorithmInfosFromHistory();
        }
        return this.recentLocalAlgoritms;
    }

    public void saveAlgorithmInfo(AlgorithmInfo algorithmInfo) throws RemoteException {
        this.saveGlobalRecents(algorithmInfo);
        this.saveLocalRecents(algorithmInfo);
        this.notifyAlgorithmUpdated();
    }

    private void saveGlobalRecents(AlgorithmInfo algorithmInfo) throws RemoteException {
        LinkedList<AlgorithmInfo> recentAlgoritms = new LinkedList();
        recentAlgoritms = this.getAlgorithmInfosFromHistory();
        this.saveRecents(algorithmInfo, recentAlgoritms);
        SharedObject sharedObj = this.readSharedObject();
        if (sharedObj == null) {
            sharedObj = this.createSharedObject(recentAlgoritms);
        } else {
            sharedObj.setContents(recentAlgoritms);
        }
        SharedObjectServiceInterface sharedObjectService = ClientRemoteLocator.sharedObjectService;
        sharedObjectService.saveSharedObject(sharedObj);
    }

    private void saveLocalRecents(AlgorithmInfo algorithmInfo) {
        LinkedList<AlgorithmInfo> recentAlgoritms = new LinkedList();
        recentAlgoritms = this.recentLocalAlgoritms;
        this.saveRecents(algorithmInfo, recentAlgoritms);
    }

    private void saveRecents(AlgorithmInfo algorithmInfo, LinkedList<AlgorithmInfo> recentAlgoritms) {
        if (recentAlgoritms.contains(algorithmInfo)) {
            recentAlgoritms.remove(algorithmInfo);
        }
        if (recentAlgoritms.size() == 5) {
            recentAlgoritms.removeLast();
        }
        recentAlgoritms.addFirst(algorithmInfo);
    }

    private SharedObject createSharedObject(Object contents) {
        SharedObject obj = new SharedObject(RECENT_ALGORITHMS_CATEGORY, User.getLoggedUser().getId(), RECENT_ALGORITHMS, true, contents);
        return obj;
    }

    public void addRecentAlgorithmsListener(RecentAlgorithmsListener listener) {
        managementList.add(listener);
    }

    private void notifyAlgorithmUpdated() {
        for (RecentAlgorithmsListener listener : managementList) {
            listener.recentAlgorithmsUpdated();
        }
    }
}

