/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.actions.core.FileExchangerAction;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeState;
import csbase.client.util.StandardErrorDialogs;
import java.awt.Component;
import java.util.ArrayList;
import tecgraf.javautils.gui.StandardDialogs;

public class ShowErrorAction
extends FileExchangerAction {
    public ShowErrorAction(FileExchanger fileExchanger) {
        super(fileExchanger);
    }

    @Override
    public void actionDone() {
        FileExchanger fileExchanger = (FileExchanger)this.getApplication();
        ApplicationFrame frame = fileExchanger.getApplicationFrame();
        ArrayList<Exchange> sels = fileExchanger.getSelectedExchangeList();
        if (sels.size() == 0) {
            String title = this.getClassString("title", new Object[0]);
            String err = this.getClassString("no.selection.error", new Object[0]);
            StandardDialogs.showErrorDialog((Component)frame, (String)title, (String)err);
            return;
        }
        int nsels = 0;
        for (Exchange sel : sels) {
            if (sel.getState() != ExchangeState.ERROR) continue;
            ++nsels;
            Exception exception = sel.getException();
            String title = sel.toString();
            StandardErrorDialogs.showExceptionDialog(frame, title, exception);
        }
        if (nsels == 0) {
            String title = this.getClassString("title", new Object[0]);
            String err = this.getClassString("no.selection.has.exception.error", new Object[0]);
            StandardDialogs.showErrorDialog((Component)frame, (String)title, (String)err);
        }
    }
}

