/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.charset;

import csbase.client.Client;
import csbase.client.util.charset.StandardCharsets;
import java.awt.Component;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import tecgraf.javautils.gui.ComboUtil;

public class CharsetComboBox
extends JComboBox {
    public CharsetComboBox() {
        this(StandardCharsets.getInstance().getAllStandardCharsets());
    }

    public CharsetComboBox(List<Charset> charsets) {
        Client client = Client.getInstance();
        Charset sysCharset = client.getSystemDefaultCharset();
        ComboUtil.updateFromList((JComboBox)this, charsets, (int)0);
        if (charsets.contains(sysCharset)) {
            this.setSelectedItem(sysCharset);
        }
        DefaultListCellRenderer rnd = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel cmp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Charset charset = (Charset)value;
                StandardCharsets stdCharsets = StandardCharsets.getInstance();
                String chName = stdCharsets.getLegibleName(charset);
                cmp.setText(chName);
                return cmp;
            }
        };
        this.setRenderer(rnd);
    }

    public final Charset getSelectedCharset() {
        Charset ch = (Charset)this.getSelectedItem();
        return ch;
    }
}

