package csbase.client.applications.sgamonitor.columns;

import javax.swing.table.TableCellRenderer;

import csbase.client.applications.sgamonitor.columns.util.PercentRenderer;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;

/**
 * Coluna que exibe o total de memria SWAP utilizado por um SGA simples.
 * 
 * @author Tecgraf
 */
public class SwapColumn extends AbstractConfigurableColumn<SGASet> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */

  public SwapColumn(String id, Boolean visible, IStringProvider stringProvider,
    Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return Integer.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGASet obj) {
    //essa coluna s  usada na tabela que monitora sga's simples
    //logo, o SGASet contm apenas um SGAInfo.
    SGAInfo node = obj.getAllInfo()[0];
    int result = (int) (100.0 - node.getSwapFreeMemory());
    return (result <= 100) ? result : -1;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return new PercentRenderer();
  }

}
