package csbase.client.algorithms.parameters;

import csbase.client.util.table.CellViewFactory;
import csbase.client.util.table.CheckBoxCellView;
import csbase.client.util.table.ReflectionCellViewFactory;
import csbase.logic.algorithms.parameters.BooleanColumn;

/**
 * Viso para {@link BooleanColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class BooleanColumnView extends
  AbstractTableColumnView<Boolean, BooleanColumn> {

  /**
   * Cria a viso de colunas.
   * 
   * @param view A viso.
   *
   * @param column A coluna (No aceita {@code null}).
   */
  public BooleanColumnView(TableParameterView view, BooleanColumn column) {
    super(view, column);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public CellViewFactory getFactory() {
    return new ReflectionCellViewFactory(CheckBoxCellView.class);
  }
}
