package csbase.client.applications.algorithmsmanager.report.implementations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.remote.ClientRemoteLocator;

/**
 * Cria e armazena um conjunto de AlgorithmInfo para ser usado como fonte de
 * dadops de um teste. Cria utilizando uma TASK REMOTA.
 *
 * @author Tecgraf/PUC-Rio
 */
public class AlgorithmInfoSource implements Iterable<AlgorithmInfo> {

  /** Lista de AlgorithmInfo */
  private List<AlgorithmInfo> list = new ArrayList<>();

  /**
   * Construtor
   * 
   * @param app Aplicao para disparar task.
   */
  public AlgorithmInfoSource(Application app) {
    RemoteTask<AlgorithmInfo[]> task = new RemoteTask<AlgorithmInfo[]>() {

      @Override
      protected void performTask() throws Exception {
        setResult(ClientRemoteLocator.algorithmService.getAllInfo());
      }
    };

    task.execute(app.getApplicationFrame(), app.getClassString(getClass(),
      "task.title"), app.getClassString(getClass(), "task.description"));

    if (task.getStatus()) {
      list = Arrays.asList(task.getResult());
    }
    else {
      list = new ArrayList<>();
    }
  }

  /** {@inheritDoc} */
  @Override
  public Iterator<AlgorithmInfo> iterator() {
    return list.iterator();
  }
}
