/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree;

import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.MutableTreeNode;

import csbase.client.applications.ApplicationImages;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         N que representa a verso de um algoritmo na rvore.
 */
public class VersionNode extends AbstractVersionTreeNode {

  /**
   * Construtor.
   * 
   * @param tree rvore que detm este n.
   * @param version Informaes da verso representada.
   */
  public VersionNode(VersionTree tree, AlgorithmVersionInfo version) {
    super(tree, version);

    add(new ExecutableNode(tree, version));
    add(new ConfigurationNode(tree, version));
    add(new DocumentationNode(tree, version));
    add(new ReleaseNotesNode(tree, version));
  }

  /**
   * Mtodo para comparao de ns. Permite ordernar os ns de verso sendo
   * exibidos, de acordo com o mtodo
   * {@link AlgorithmVersionInfo#compareTo(AlgorithmVersionInfo)}
   */
  @Override
  public int compareTo(MutableTreeNode node) {
    if (node instanceof VersionNode) {
      VersionNode versionNode = (VersionNode) node;

      AlgorithmVersionInfo version = (AlgorithmVersionInfo) this
        .getUserObject();
      AlgorithmVersionInfo other = (AlgorithmVersionInfo) versionNode
        .getUserObject();
      return version.compareTo(other);
    }
    else {
      return super.compareTo(node);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon() {
    return ApplicationImages.ICON_FOLDER_16;
  }

  /**
   * Cria um menu pop-up para este n.
   * 
   * @return um menu pop-up para este n.
   */
  @Override
  public JPopupMenu createPopupMenu() {
    JPopupMenu popupMenu = new JPopupMenu();
    // popupMenu.add(new JMenuItem(new ShowHistory(getWindow(), this)));
    // popupMenu.add(new JMenuItem(new DuplicateVersion(getTree(),
    // getAlgorithmVersionInfo())));
    // popupMenu.add(new JMenuItem(new RemoveVersion(getTree(),
    // getAlgorithmVersionInfo())));
    // Caso hajam atributos estendidos, adiciona um tem de propriedades.
    // int propertySize =
    // AlgorithmManagementProxy.getAlgorithmVersionProperties(
    // getWindow()).size();
    // if (0 < propertySize) {
    // popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
    // new ShowVersionProperties(getTree(), getAlgorithmVersionInfo()))));
    // }

    return popupMenu;
  }

  //  /**
  //   * Obtm as informaes da verso representada por este n.
  //   * 
  //   * @return as informaes da verso representada por este n.
  //   */
  //  private AlgorithmVersionInfo getAlgorithmVersionInfo() {
  //    return (AlgorithmVersionInfo) getUserObject();
  //  }
}
