/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.util.Locale;

import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo o nome do sga responsvel pelo comando.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class ServerColumn extends AbstractCommandsTableColumn {

  /**
   * Construtor.
   * 
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public ServerColumn(String id, ApplicationRegistry appRegistry) {
    super(String.class, id, appRegistry);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    if (cmd.getStatus() == CommandStatus.SYSTEM_FAILURE) {
      return getDefaultErrorValue();
    }
    else if (cmd.getSGAName() == null) {
      return getDefaultEmptyValue();
    }
    else {
      return cmd.getSGAName();
    }
  }
}
