/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.util.Locale;

import csbase.logic.CommandInfo;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo o usurio que requisitou a execuo do comando.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class UserColumn extends AbstractCommandsTableColumn {

  /**
   * Construtor.
   * 
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public UserColumn(String id, ApplicationRegistry appRegistry) {
    super(String.class, id, appRegistry);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    try {
      Object userId = cmd.getUserId();
      if (userId == null) {
        return getDefaultErrorValue();
      }
      User user = User.getUser(userId);
      if (user == null) {
        return getDefaultErrorValue();
      }
      return user.getName();
    }
    catch (Exception e) {
      return getDefaultErrorValue();
    }
  }
}
